package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

/**
 * Created by mika on 2016. 12. 6..
 */
class UserChatHolder extends RecyclerView.ViewHolder
    implements View.OnClickListener, View.OnLongClickListener {

  public static UserChatHolder newInstance(ViewGroup parent, OnUserChatClickListener listener) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());
    View itemView = inflater.inflate(R.layout.ch_plugin_item_user_chat, parent, false);
    return new UserChatHolder(itemView, listener);
  }

  private Context context;

  private AvatarLayout avatar;
  private TextView textName, textMessage, textTime, textBadge;
  private UserChat userChat;

  private OnUserChatClickListener listener;

  UserChatHolder(View itemView, OnUserChatClickListener listener) {
    super(itemView);

    this.context = itemView.getContext();
    this.listener = listener;

    avatar = (AvatarLayout) itemView.findViewById(R.id.avatar_single);
    avatar.setTextSize(16);

    textName = (TextView) itemView.findViewById(R.id.text_name);
    textMessage = (TextView) itemView.findViewById(R.id.text_message);
    textTime = (TextView) itemView.findViewById(R.id.text_time);
    textBadge = (TextView) itemView.findViewById(R.id.text_badge);

    itemView.setOnClickListener(this);
    itemView.setOnLongClickListener(this);
  }

  void setUserChatItem(UserChatItem item) {
    this.userChat = item.getUserChat();

    Message message = item.getMessage();
    Session session = item.getSession();
    ProfileEntity profileEntity = item.getProfile();

    avatar.set(profileEntity);
    textName.setText(profileEntity == null
        ? ResUtils.getString(context, "ch.unknown")
        : profileEntity.getName());

    setTextMessage(message);
    setTextTime(message);

    if (session != null && session.getAlert() != null && session.getAlert() > 0) {
      textBadge.setVisibility(View.VISIBLE);
      textBadge.setText(Utils.getCount(session.getAlert(), true));
    } else {
      textBadge.setVisibility(View.INVISIBLE);
    }
  }

  private void setTextMessage(Message message) {
    if (userChat.isStateResolved()) {
      textMessage.setText(ResUtils.getString(context, "ch.review.require.preview"));
      textMessage.setTextColor(ContextCompat.getColor(context, R.color.ch_dark));
    } else if (userChat.isStateClosed()) {
      textMessage.setText(ResUtils.getString(context, "ch.review.complete.preview"));
      textMessage.setTextColor(ContextCompat.getColor(context, R.color.ch_light));
    } else {
      textMessage.setTextColor(ContextCompat.getColor(context, R.color.ch_dark));

      if (message != null) {
        if (message.getMessage() != null) {
          textMessage.setText(message.getMessage());
        } else if (message.getFile() != null) {
          if (message.getFile().isImage()) {
            textMessage.setText(ResUtils.getString(context, "ch.notification.upload_image.description"));
          } else {
            textMessage.setText(ResUtils.getString(context, "ch.notification.upload_file.description"));
          }
        } else {
          textMessage.setText("");
        }
      } else {
        textMessage.setText("");
      }
    }
  }

  private void setTextTime(Message message) {
    if (userChat != null) {
      if (userChat.isStateResolved()) {
        textTime.setText(TimeUtils.get(userChat.getResolvedAt()));
      } else {
        if (message != null) {
          textTime.setText(TimeUtils.get(message.getCreatedAt()));
        } else {
          textTime.setText(TimeUtils.get(userChat.getUpdatedAt()));
        }
      }
    } else {
      textTime.setText(" ");
    }
  }

  public String getChatId() {
    if (userChat != null) {
      return userChat.getId();
    }
    return null;
  }

  @Override
  public void onClick(View view) {
    listener.onUserChatClick(getChatId());
  }

  @Override
  public boolean onLongClick(View v) {
    listener.onUserChatLongClick(getChatId());
    return true;
  }
}
