package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnUserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

/**
 * Created by mika on 2017. 2. 7..
 */
public class UserInfoMessageHolder extends RecyclerView.ViewHolder implements View.OnClickListener {

  private Context context;
  private LinearLayout inputLayout, completeLayout;
  private TextView title, errorTitle, description, country;
  private LinearLayout inputLayouts, nameLayout, phoneLayout, countryLayout;
  private WatchedEditText nameEdit, phoneEdit;
  private Button nameButton, phoneButton;

  private OnUserInfoListener listener;
  private UserInfoItem item;

  private String code, mobileNumber;
  private boolean handle = false;
  private int checkedPosition;

  public UserInfoMessageHolder(
      View itemView,
      final OnUserInfoListener listener) {
    super(itemView);

    context = itemView.getContext();

    inputLayout = (LinearLayout) itemView.findViewById(R.id.layout_user_info_input);
    completeLayout = (LinearLayout) itemView.findViewById(R.id.layout_user_info_complete);

    title = (TextView) itemView.findViewById(R.id.user_info_title);
    errorTitle = (TextView) itemView.findViewById(R.id.user_info_error_title);
    description = (TextView) itemView.findViewById(R.id.user_info_description);

    inputLayouts = (LinearLayout) itemView.findViewById(R.id.user_info_layout);
    nameLayout = (LinearLayout) itemView.findViewById(R.id.user_info_layout_name);
    phoneLayout = (LinearLayout) itemView.findViewById(R.id.user_info_layout_phone);

    nameEdit = (WatchedEditText) itemView.findViewById(R.id.user_info_layout_name_input);
    nameButton = (Button) itemView.findViewById(R.id.user_info_layout_name_button);

    country = (TextView) itemView.findViewById(R.id.user_info_layout_phone_country);
    countryLayout = (LinearLayout) itemView.findViewById(R.id.user_info_layout_phone_country_layout);
    phoneEdit = (WatchedEditText) itemView.findViewById(R.id.user_info_layout_phone_input);
    phoneButton = (Button) itemView.findViewById(R.id.user_info_layout_phone_button);

    int active = ContextCompat.getColor(context, R.color.ch_cobalt);
    int deactive = ContextCompat.getColor(context, R.color.ch_light);

    nameEdit.setHandledButton(nameButton, active, deactive);
    nameEdit.setWatchedTextChangedListener(new EditTextChangedListener() {
      @Override
      public void onWatchedTextChanged(String s) {
        if (listener != null && handle) {
          listener.userInfoChanged(s);
        }
      }
    });
    nameEdit.setOnEditorActionListener(new TextView.OnEditorActionListener() {
      @Override
      public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
          case EditorInfo.IME_ACTION_SEND:
            nameButton.callOnClick();
            break;
          default:
            return false;
        }
        return true;
      }
    });
    phoneEdit.setHandledButton(phoneButton, active, deactive);
    phoneEdit.setWatchedTextChangedListener(new EditTextChangedListener() {
      @Override
      public void onWatchedTextChanged(String s) {
        if (listener != null && handle) {
          listener.userInfoChanged(new MobileNumberItem(code, s, checkedPosition));
        }
        mobileNumber = s;
      }
    });
    phoneEdit.setOnEditorActionListener(new TextView.OnEditorActionListener() {
      @Override
      public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
          case EditorInfo.IME_ACTION_SEND:
            phoneButton.callOnClick();
            break;
          default:
            return false;
        }
        return true;
      }
    });

    nameButton.setOnClickListener(this);
    phoneButton.setOnClickListener(this);
    countryLayout.setOnClickListener(this);

    code = "";
    mobileNumber = "";
    checkedPosition = -1;

    this.listener = listener;
  }

  private void initLayout(UserInfoItem item) {
    title.setVisibility(UIUtils.getVisible(!item.hasError(), true));
    errorTitle.setVisibility(UIUtils.getVisible(item.hasError(), true));

    inputLayout.setVisibility(UIUtils.getVisible(!UserInfoType.COMPLETE.equals(item.getUserInfoType()), true));
    completeLayout.setVisibility(UIUtils.getVisible(UserInfoType.COMPLETE.equals(item.getUserInfoType()), true));

    for (int i = 0; i < inputLayouts.getChildCount(); i++) {
      inputLayouts.getChildAt(i).setVisibility(View.GONE);
    }

    switch (item.getUserInfoType()) {
      case NAME:
        nameLayout.setVisibility(View.VISIBLE);
        break;

      case MOBILE_NUMBER:
        phoneLayout.setVisibility(View.VISIBLE);
        break;
    }
  }

  private String getString(String string) {
    return ResUtils.getString(context, string);
  }

  public void set(UserInfoItem item) {
    this.item = item;
    ChatDataDictionary dictionary = ChatDataDictionary.getInstance();
    initLayout(item);
    handle = true;

    switch (item.getUserInfoType()) {
      case NAME:
        nameEdit.setText(dictionary.getUserName());

        if (item.hasError()) {
          errorTitle.setText(getString("ch.name_verification.error.title"));
          description.setText(item.getError());

          nameEdit.selectAll();
        } else {
          title.setText(getString("ch.name_verification.title"));
          description.setText(getString("ch.name_verification.description"));
        }
        break;

      case MOBILE_NUMBER:
        MobileNumberItem mobileNumberItem = dictionary.getUserMobilNumber();
        if (mobileNumberItem != null) {
          code = mobileNumberItem.getCountry();
          mobileNumber = mobileNumberItem.getMobileNumber();
          checkedPosition = mobileNumberItem.getCheckedPosition();

          country.setText(String.format("+%s", mobileNumberItem.getCountry()));
          phoneEdit.setText(mobileNumberItem.getMobileNumber());
        }

        if (item.hasError()) {
          errorTitle.setText(getString("ch.mobile_verification.error.title"));
          description.setText(item.getError());

          phoneEdit.selectAll();
        } else {
          title.setText(getString("ch.mobile_verification.title"));
          description.setText(getString("ch.mobile_verification.description"));
        }
        break;
    }
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();
    if (id == R.id.user_info_layout_phone_country_layout) {
      if (listener != null && handle) {
        listener.getCountries(getAdapterPosition());
      }
    }
    if (id == R.id.user_info_layout_name_button || id == R.id.user_info_layout_phone_button) {
      if (listener != null && item != null && handle) {
        listener.sendUserInfo(item);
      }
    }
  }
}
