package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.CloseMessageItem;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class CloseMessageHolder extends RecyclerView.ViewHolder {

  private Context context;
  private ImageView imageReview;
  private TextView textTitle;

  public CloseMessageHolder(View itemView) {
    super(itemView);

    context = itemView.getContext();
    imageReview = (ImageView) itemView.findViewById(R.id.iv_user_chat_review);
    textTitle = (TextView) itemView.findViewById(R.id.tv_user_chat_closed_title);
  }

  public void bind(CloseMessageItem item) {
    UserChat userChat = item.getUserChat();
    if (userChat != null) {
      String review = userChat.getReview();

      if (Const.USER_CHAT_REVIEW_LIKE.equals(review)) {
        imageReview.setImageResource(R.drawable.ch_plugin_happy_face_large);
        textTitle.setText(ResUtils.getString(context, "ch.review.complete.title"));
      } else if (Const.USER_CHAT_REVIEW_DISLIKE.equals(review)) {
        imageReview.setImageResource(R.drawable.ch_plugin_angry_face_large);
        textTitle.setText(ResUtils.getString(context, "ch.review.complete.title"));
      } else {
        imageReview.setImageResource(R.drawable.ch_plugin_neutral_face);
        textTitle.setText(ResUtils.getString(context, "ch.review.cancel"));
      }
    }
  }
}
