package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.activity.base.BaseDictionary;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Script;
import com.zoyi.channel.plugin.android.util.CountryUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Created by mika on 2016. 12. 8..
 */
public class ChatDataDictionary extends BaseDictionary {

  private static ChatDataDictionary instance;
  public static ChatDataDictionary getInstance() {
    if (instance == null) {
      synchronized (ChatDataDictionary.class) {
        if (instance == null) {
          instance = new ChatDataDictionary();
        }
      }
    }
    return instance;
  }

  private List<Manager> follingManagers;
  private Map<String, Script> scriptMap;
  private String userName;
  private MobileNumberItem userMobilNumber;

  private ChatDataDictionary() {
    super();
    follingManagers = new ArrayList<>();
    scriptMap = new HashMap<>();
    userMobilNumber = new MobileNumberItem(CountryUtils.getDefaultCountryCode(), "", -1);
  }

  @Override
  public void release() {
    super.release();
    if (follingManagers != null) {
      follingManagers.clear();
    }
    if (scriptMap != null) {
      scriptMap.clear();
    }
    userName = null;
    userMobilNumber = new MobileNumberItem(CountryUtils.getDefaultCountryCode(), "", -1);
  }

  @Override
  public <E extends ChannelModel> E get(Class<E> clazz, String id) {
    if (id != null) {
      String className = clazz.getSimpleName();
      switch (className) {
        case Manager.CLASSNAME:
          return (E) managerMap.get(id);

        case Bot.CLASSNAME:
          return (E) botMap.get(id);
      }
    }
    return null;
  }

  @Override
  public void add(List<? extends ChannelModel> channelModels) {
    if (channelModels != null) {
      for (ChannelModel channelModel : channelModels) {
        if (checkCanUpdate(channelModel)) {
          String className = channelModel.getClass().getSimpleName();
          switch (className) {
            case Manager.CLASSNAME:
              managerMap.put(channelModel.getId(), (Manager) channelModel);
              break;

            case Bot.CLASSNAME:
              botMap.put(channelModel.getId(), (Bot) channelModel);
              break;
          }
        }
      }
    }
  }

  @Override
  protected void remove(ChannelModel channelModel) {
    // do nothing...
  }

  public void setFollowingManagers(List<Manager> managers) {
    this.follingManagers = managers;
  }

  public List<Manager> getFollingManagers() {
    return follingManagers;
  }

  public void setScripts(List<Script> scripts) {
    if (scripts != null) {
      for (Script script : scripts) {
        if (script.getKey() != null && script.getMessage() != null) {
          scriptMap.put(script.getKey(), script);
        }
      }
    }
  }

  public String getScript(Context context, String key, String defaultResourceKey) {
    if (scriptMap != null && scriptMap.containsKey(key)) {
      String message = scriptMap.get(key).getMessage(Locale.getDefault().getLanguage());

      if (!TextUtils.isEmpty(message)) {
        return message;
      }
    }
    return ResUtils.getString(context, defaultResourceKey);
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public void setUserMobilNumber(MobileNumberItem userMobilNumber) {
    this.userMobilNumber = userMobilNumber;
  }

  public String getUserName() {
    return userName;
  }

  public MobileNumberItem getUserMobilNumber() {
    return userMobilNumber;
  }
}
