/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Single;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.SingleFromObservable;
import com.zoyi.rx.internal.producers.SingleProducer;
import com.zoyi.rx.plugins.RxJavaHooks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleLiftObservableOperator<T, R>
implements Single.OnSubscribe<R> {
    final Single.OnSubscribe<T> source;
    final Observable.Operator<? extends R, ? super T> lift;

    public SingleLiftObservableOperator(Single.OnSubscribe<T> source, Observable.Operator<? extends R, ? super T> lift) {
        this.source = source;
        this.lift = lift;
    }

    @Override
    public void call(SingleSubscriber<? super R> t) {
        SingleFromObservable.WrapSingleIntoSubscriber<? super R> outputAsSubscriber = new SingleFromObservable.WrapSingleIntoSubscriber<R>(t);
        t.add(outputAsSubscriber);
        try {
            Subscriber inputAsSubscriber = (Subscriber)RxJavaHooks.onSingleLift(this.lift).call(outputAsSubscriber);
            SingleSubscriber<T> input = SingleLiftObservableOperator.wrap(inputAsSubscriber);
            inputAsSubscriber.onStart();
            this.source.call(input);
        }
        catch (Throwable ex) {
            Exceptions.throwOrReport(ex, t);
        }
    }

    public static <T> SingleSubscriber<T> wrap(Subscriber<T> subscriber) {
        WrapSubscriberIntoSingle<T> parent = new WrapSubscriberIntoSingle<T>(subscriber);
        subscriber.add(parent);
        return parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WrapSubscriberIntoSingle<T>
    extends SingleSubscriber<T> {
        final Subscriber<? super T> actual;

        WrapSubscriberIntoSingle(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onSuccess(T value) {
            this.actual.setProducer(new SingleProducer<T>(this.actual, value));
        }

        @Override
        public void onError(Throwable error) {
            this.actual.onError(error);
        }
    }
}

