/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnSubscribeFromIterable<T>
implements Observable.OnSubscribe<T> {
    final Iterable<? extends T> is;

    public OnSubscribeFromIterable(Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable must not be null");
        }
        this.is = iterable;
    }

    @Override
    public void call(Subscriber<? super T> o) {
        boolean b;
        Iterator<T> it;
        try {
            it = this.is.iterator();
            b = it.hasNext();
        }
        catch (Throwable ex) {
            Exceptions.throwOrReport(ex, o);
            return;
        }
        if (!o.isUnsubscribed()) {
            if (!b) {
                o.onCompleted();
            } else {
                o.setProducer(new IterableProducer<T>(o, it));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IterableProducer<T>
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = -8730475647105475802L;
        private final Subscriber<? super T> o;
        private final Iterator<? extends T> it;

        IterableProducer(Subscriber<? super T> o, Iterator<? extends T> it) {
            this.o = o;
            this.it = it;
        }

        @Override
        public void request(long n) {
            if (this.get() == Long.MAX_VALUE) {
                return;
            }
            if (n == Long.MAX_VALUE && this.compareAndSet(0L, Long.MAX_VALUE)) {
                this.fastPath();
            } else if (n > 0L && BackpressureUtils.getAndAddRequest(this, n) == 0L) {
                this.slowPath(n);
            }
        }

        void slowPath(long n) {
            Subscriber<T> o = this.o;
            Iterator<T> it = this.it;
            long r = n;
            long e = 0L;
            while (true) {
                if (e != r) {
                    boolean b;
                    T value;
                    if (o.isUnsubscribed()) {
                        return;
                    }
                    try {
                        value = it.next();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwOrReport(ex, o);
                        return;
                    }
                    o.onNext(value);
                    if (o.isUnsubscribed()) {
                        return;
                    }
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwOrReport(ex, o);
                        return;
                    }
                    if (!b) {
                        if (!o.isUnsubscribed()) {
                            o.onCompleted();
                        }
                        return;
                    }
                    ++e;
                    continue;
                }
                r = this.get();
                if (e != r) continue;
                r = BackpressureUtils.produced(this, e);
                if (r == 0L) break;
                e = 0L;
            }
        }

        void fastPath() {
            boolean b;
            Subscriber<T> o = this.o;
            Iterator<T> it = this.it;
            do {
                T value;
                if (o.isUnsubscribed()) {
                    return;
                }
                try {
                    value = it.next();
                }
                catch (Throwable ex) {
                    Exceptions.throwOrReport(ex, o);
                    return;
                }
                o.onNext(value);
                if (o.isUnsubscribed()) {
                    return;
                }
                try {
                    b = it.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwOrReport(ex, o);
                    return;
                }
            } while (b);
            if (!o.isUnsubscribed()) {
                o.onCompleted();
            }
        }
    }
}

