/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnUserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import java.util.Locale;

public class UserInfoMessageHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private Context context;
    private LinearLayout inputLayout;
    private LinearLayout completeLayout;
    private TextView title;
    private TextView errorTitle;
    private TextView description;
    private TextView agreement;
    private TextView country;
    private LinearLayout inputLayouts;
    private LinearLayout nameLayout;
    private LinearLayout phoneLayout;
    private LinearLayout countryLayout;
    private WatchedEditText nameEdit;
    private WatchedEditText phoneEdit;
    private Button nameButton;
    private Button phoneButton;
    private OnUserInfoListener listener;
    private String code;
    private String mobileNumber;
    private boolean handle = false;
    private int checkedPosition;

    public UserInfoMessageHolder(View itemView, final OnUserInfoListener listener) {
        super(itemView);
        this.context = itemView.getContext();
        this.inputLayout = (LinearLayout)itemView.findViewById(R.id.layout_user_info_input);
        this.completeLayout = (LinearLayout)itemView.findViewById(R.id.layout_user_info_complete);
        this.title = (TextView)itemView.findViewById(R.id.user_info_title);
        this.errorTitle = (TextView)itemView.findViewById(R.id.user_info_error_title);
        this.description = (TextView)itemView.findViewById(R.id.user_info_description);
        this.agreement = (TextView)itemView.findViewById(R.id.user_info_agreement);
        this.inputLayouts = (LinearLayout)itemView.findViewById(R.id.user_info_layout);
        this.nameLayout = (LinearLayout)itemView.findViewById(R.id.user_info_layout_name);
        this.phoneLayout = (LinearLayout)itemView.findViewById(R.id.user_info_layout_phone);
        this.nameEdit = (WatchedEditText)itemView.findViewById(R.id.user_info_layout_name_input);
        this.nameButton = (Button)itemView.findViewById(R.id.user_info_layout_name_button);
        this.country = (TextView)itemView.findViewById(R.id.user_info_layout_phone_country);
        this.countryLayout = (LinearLayout)itemView.findViewById(R.id.user_info_layout_phone_country_layout);
        this.phoneEdit = (WatchedEditText)itemView.findViewById(R.id.user_info_layout_phone_input);
        this.phoneButton = (Button)itemView.findViewById(R.id.user_info_layout_phone_button);
        int active = ContextCompat.getColor((Context)this.context, (int)R.color.ch_cobalt);
        int deactive = ContextCompat.getColor((Context)this.context, (int)R.color.ch_light);
        this.nameEdit.setHandledButton(this.nameButton, active, deactive);
        this.nameEdit.setWatchedTextChangedListener(new EditTextChangedListener(){

            @Override
            public void onWatchedTextChanged(String s) {
                if (listener != null && UserInfoMessageHolder.this.handle) {
                    listener.userInfoChanged(s);
                }
            }
        });
        this.phoneEdit.setHandledButton(this.phoneButton, active, deactive);
        this.phoneEdit.setWatchedTextChangedListener(new EditTextChangedListener(){

            @Override
            public void onWatchedTextChanged(String s) {
                if (listener != null && UserInfoMessageHolder.this.handle) {
                    listener.userInfoChanged(new MobileNumberItem(UserInfoMessageHolder.this.code, s, UserInfoMessageHolder.this.checkedPosition));
                }
                UserInfoMessageHolder.this.mobileNumber = s;
            }
        });
        this.nameButton.setOnClickListener((View.OnClickListener)this);
        this.phoneButton.setOnClickListener((View.OnClickListener)this);
        this.countryLayout.setOnClickListener((View.OnClickListener)this);
        this.agreement.setText((CharSequence)Html.fromHtml((String)ResUtils.getString(this.context, "ch.agreement")));
        this.agreement.setOnClickListener((View.OnClickListener)this);
        this.code = "";
        this.mobileNumber = "";
        this.checkedPosition = -1;
        this.listener = listener;
    }

    private void initLayout(UserInfoItem item) {
        this.title.setVisibility(UIUtils.getVisible(!item.isError(), true));
        this.errorTitle.setVisibility(UIUtils.getVisible(item.isError(), true));
        this.inputLayout.setVisibility(UIUtils.getVisible(!UserInfoType.COMPLETE.equals((Object)item.getUserInfoType()), true));
        this.completeLayout.setVisibility(UIUtils.getVisible(UserInfoType.COMPLETE.equals((Object)item.getUserInfoType()), true));
        for (int i = 0; i < this.inputLayouts.getChildCount(); ++i) {
            this.inputLayouts.getChildAt(i).setVisibility(8);
        }
        switch (item.getUserInfoType()) {
            case NAME: {
                this.nameLayout.setVisibility(0);
                break;
            }
            case MOBILE_NUMBER: {
                this.phoneLayout.setVisibility(0);
            }
        }
    }

    private String getString(String string2) {
        return ResUtils.getString(this.context, string2);
    }

    public void set(UserInfoItem item) {
        this.initLayout(item);
        this.setAgreementVisibility();
        this.handle = true;
        switch (item.getUserInfoType()) {
            case NAME: {
                if (item.getObject() != null && item.getObject() instanceof String) {
                    String name = (String)item.getObject();
                    this.nameEdit.setText(name);
                }
                if (item.isError()) {
                    this.errorTitle.setText((CharSequence)this.getString("ch.name_verification.title"));
                    this.description.setText((CharSequence)this.getString("ch.name_verification.description"));
                    this.nameEdit.selectAll();
                    break;
                }
                this.title.setText((CharSequence)this.getString("ch.name_verification.title"));
                this.description.setText((CharSequence)this.getString("ch.name_verification.description"));
                break;
            }
            case MOBILE_NUMBER: {
                if (item.getObject() != null && item.getObject() instanceof MobileNumberItem) {
                    MobileNumberItem mobileNumberItem = (MobileNumberItem)item.getObject();
                    this.code = mobileNumberItem.getCountry();
                    this.mobileNumber = mobileNumberItem.getMobileNumber();
                    this.checkedPosition = mobileNumberItem.getCheckedPosition();
                    this.country.setText((CharSequence)String.format("+%s", mobileNumberItem.getCountry()));
                    this.phoneEdit.setText(mobileNumberItem.getMobileNumber());
                }
                if (item.isError()) {
                    this.errorTitle.setText((CharSequence)this.getString("ch.mobile_verification.error.title"));
                    this.description.setText((CharSequence)this.getString("ch.mobile_verification.error.description"));
                    this.phoneEdit.selectAll();
                    break;
                }
                this.title.setText((CharSequence)this.getString("ch.mobile_verification.title"));
                this.description.setText((CharSequence)this.getString("ch.mobile_verification.description"));
            }
        }
    }

    private void setAgreementVisibility() {
        String lang = Locale.getDefault().getLanguage();
        if (lang.equalsIgnoreCase("ko") || lang.equalsIgnoreCase("ja")) {
            this.agreement.setVisibility(0);
        } else {
            this.agreement.setVisibility(8);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.user_info_layout_phone_country_layout && this.listener != null && this.handle) {
            this.listener.getCountries(this.getAdapterPosition());
        }
        if ((id2 == R.id.user_info_layout_name_button || id2 == R.id.user_info_layout_phone_button) && this.listener != null && this.handle) {
            this.listener.sendUserInfo();
        }
        if (id2 == R.id.user_info_agreement) {
            String channelName = ChannelStore.getChannel() != null ? ChannelStore.getChannel().getName() : "";
            Executor.goWeb(this.context, String.format("http://channel.io/%s/terms_user?channel=%s", Locale.getDefault().getLanguage(), channelName));
        }
    }
}

