package com.zoyi.channel.plugin.android.presenter.userchat;

import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.userchat.UserChatListState;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.BasePresenter;
import com.zoyi.channel.plugin.android.presenter.BaseView;

public interface UserChatContract {

  interface View extends BaseView<Presenter> {

    void userChatsFetched(UserChatsWrapper userChatsWrapper);
    void startChat(String chatId, int chatCount, boolean chatEmpty);
    void setRefreshVisibility(boolean showRefresh);
    void setReconnectVisibility(boolean show);

    void checkUserChat(boolean hasCheckedChat);
    void deleteChat(String chatId);
    void completeRemoveChat();
  }

  interface Presenter extends BasePresenter<View> {

    void setAdapterView(UserChatAdapterContract.View adapterView);
    void setAdapterModel(UserChatAdapterContract.Model adapterModel);
    void setRunningChatId(String runningChatId);
    void setInit(boolean init);
    int getChatCount(String chatId);
    void refresh();
    void setState(UserChatListState state);
    void getUserChats();
    void receiveCommand(Command command, Object object);
    void receiveData(ChannelModel channelModel, boolean upsert);

    void requestRemoveChat(String chatId);
    void requestRemoveChats();

    void setEditMode(boolean editMode);
  }

}
