package com.zoyi.channel.plugin.android.lib;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;

import com.zoyi.channel.plugin.android.model.rest.Country;

import java.util.ArrayList;
import java.util.List;

public class CountryCodeDialog extends AlertDialog.Builder {

  public interface OnCountryCodeSelectListener {

    void onCountryCodeSelected(int position, String countryCode);
  }

  public CountryCodeDialog(
      @NonNull Context context,
      int checkedPosition,
      final List<Country> countries,
      final OnCountryCodeSelectListener listener) {
    super(context);

    setSingleChoiceItems(getItems(countries), checkedPosition, new DialogInterface.OnClickListener() {
      @Override
      public void onClick(DialogInterface dialog, int which) {
        if (listener != null) {
          listener.onCountryCodeSelected(which, countries.get(which).getCallingCode());
        }
        dialog.dismiss();
      }
    });
  }

  private String[] getItems(List<Country> countries) {
    ArrayList<String> items = new ArrayList<>();

    for (Country country : countries) {
      items.add(String.format("%s (+%s)", country.getName(), country.getCallingCode()));
    }
    return items.toArray(new String[items.size()]);
  }
}
