/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import com.splunk.mint.ActionTimer;
import com.splunk.mint.Utils;
import java.util.concurrent.ConcurrentHashMap;

class TimerManager {
    private static TimerManager instance = null;
    ConcurrentHashMap<String, Timer> timers = new ConcurrentHashMap();

    protected TimerManager() {
    }

    public static TimerManager getInstance() {
        if (instance == null) {
            instance = new TimerManager();
        }
        return instance;
    }

    public String timerStart(String timerName) {
        Timer timer = new Timer(timerName);
        String id = Utils.getRandomSessionNumber();
        this.timers.put(id, timer);
        return id;
    }

    public void timerStop(String id) {
        Timer timer = this.timers.get(id);
        if (timer == null) {
            return;
        }
        timer.stop();
        ActionTimer.createTimer(timer.getName(), timer.getElapsedTime()).save();
    }

    class Timer {
        long startTime = System.nanoTime();
        long elapsedTime = -1L;
        final String name;

        public Timer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public void stop() {
            this.elapsedTime = System.nanoTime() - this.startTime;
        }
    }
}

