/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.presenter.settings;

import android.content.Context;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.wrapper.CountryWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserVeilWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.presenter.settings.ProfileEditContract;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;

public class ProfileEditPresenter
implements ProfileEditContract.Presenter {
    private Context context;
    private ProfileEditContract.View view;
    private List<Country> countries;

    public ProfileEditPresenter(Context context) {
        this.context = context;
        this.countries = new ArrayList<Country>();
    }

    @Override
    public void setView(ProfileEditContract.View view) {
        this.view = view;
    }

    @Override
    public void updateUserName(String name) {
        this.updateUser(RequestUtils.form().set("name", name).create());
    }

    @Override
    public void updateUserMobileNumber(String mobileNumber) {
        this.updateUser(RequestUtils.form().set("mobileNumber", mobileNumber).create());
    }

    private void updateUser(RequestBody body) {
        this.view.showProgress(ResUtils.getString(this.context, "ch.settings.changing_message"));
        ChannelPlugin.getApi().updateGuest(body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserVeilWrapper>(){

            @Override
            public void onError(RetrofitException e) {
                ProfileEditPresenter.this.view.hideProgress();
                ProfileEditPresenter.this.view.onShowFailedMessage(e.getMessage());
            }

            @Override
            public void onNext(UserVeilWrapper wrapper) {
                ProfileEditPresenter.this.view.hideProgress();
                if (wrapper != null) {
                    ChannelStore.setUserVeil(wrapper.getUser(), wrapper.getVeil());
                    ProfileEditPresenter.this.view.onUpdateSuccessed();
                }
            }
        });
    }

    @Override
    public void getCountries() {
        if (this.countries == null || this.countries.isEmpty()) {
            this.view.showProgress(ResUtils.getString(this.context, "ch.loading_information"));
            ChannelPlugin.getApi().getCountries().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<CountryWrapper>(){

                @Override
                public void onError(RetrofitException e) {
                    ProfileEditPresenter.this.view.hideProgress();
                    ProfileEditPresenter.this.view.onShowFailedMessage(e.getMessage());
                }

                @Override
                public void onNext(CountryWrapper countryWrapper) {
                    ProfileEditPresenter.this.view.hideProgress();
                    if (countryWrapper != null) {
                        ProfileEditPresenter.this.countries = countryWrapper.getCountries();
                        ProfileEditPresenter.this.view.onLoadedCountries(ProfileEditPresenter.this.countries);
                    }
                }
            });
        } else {
            this.view.onLoadedCountries(this.countries);
        }
    }
}

