/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;

public class SettingsActivity
extends BaseActivity
implements View.OnClickListener {
    private Channel channel;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_profile);
        this.channel = ChannelStore.getChannel();
        Plugin plugin = ChannelStore.getPlugin();
        if (this.channel == null || plugin == null) {
            this.finish();
            return;
        }
        this.setBigBar(plugin);
        this.findViewById(R.id.iv_channel_symbol).setOnClickListener((View.OnClickListener)this);
    }

    private void setBigBar(Plugin plugin) {
        this.getBigBar().withActivity(this).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT).build();
        this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
        this.getBigBar().setTitle(ResUtils.getString((Context)this, "ch.settings.title"));
        this.setStatusBarColor(plugin.getBackgroundColor());
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.iv_channel_symbol) {
            Executor.goWeb((Context)this, this.getUrl());
        }
    }

    private String getUrl() {
        return String.format("https://channel.io/?utm_campaign=plugin_exposure_android&utm_medium=plugin&utm_source=%s", this.channel == null ? null : this.channel.getName());
    }
}

