/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.adapter.rxjava;

import com.zoyi.retrofit2.Call;
import com.zoyi.retrofit2.CallAdapter;
import com.zoyi.retrofit2.adapter.rxjava.BodyOnSubscribe;
import com.zoyi.retrofit2.adapter.rxjava.CallEnqueueOnSubscribe;
import com.zoyi.retrofit2.adapter.rxjava.CallExecuteOnSubscribe;
import com.zoyi.retrofit2.adapter.rxjava.ResultOnSubscribe;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Scheduler;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

final class RxJavaCallAdapter<R>
implements CallAdapter<R, Object> {
    private final Type responseType;
    @Nullable
    private final Scheduler scheduler;
    private final boolean isAsync;
    private final boolean isResult;
    private final boolean isBody;
    private final boolean isSingle;
    private final boolean isCompletable;

    RxJavaCallAdapter(Type responseType, @Nullable Scheduler scheduler, boolean isAsync, boolean isResult, boolean isBody, boolean isSingle, boolean isCompletable) {
        this.responseType = responseType;
        this.scheduler = scheduler;
        this.isAsync = isAsync;
        this.isResult = isResult;
        this.isBody = isBody;
        this.isSingle = isSingle;
        this.isCompletable = isCompletable;
    }

    public Type responseType() {
        return this.responseType;
    }

    public Object adapt(Call<R> call) {
        Object callFunc;
        Object object = callFunc = this.isAsync ? new CallEnqueueOnSubscribe<R>(call) : new CallExecuteOnSubscribe<R>(call);
        Object func = this.isResult ? new ResultOnSubscribe(callFunc) : (this.isBody ? new BodyOnSubscribe(callFunc) : callFunc);
        Observable observable = Observable.create(func);
        if (this.scheduler != null) {
            observable = observable.subscribeOn(this.scheduler);
        }
        if (this.isSingle) {
            return observable.toSingle();
        }
        if (this.isCompletable) {
            return observable.toCompletable();
        }
        return observable;
    }
}

