package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.lang.DateUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * Created by mika on 2016. 1. 21..
 */
public class TimeUtils {
  public final static SimpleDateFormat FULL_YEAR = new SimpleDateFormat("yyyy", Locale.getDefault());
  public final static SimpleDateFormat FULL_DAY = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
  public final static SimpleDateFormat FULL_MINUTE = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());

  public final static SimpleDateFormat SIMPLE_DAY = new SimpleDateFormat("yyyy-M-d", Locale.getDefault());
  public final static SimpleDateFormat SIMPLE_DATE = new SimpleDateFormat("M/d", Locale.getDefault());
  public final static SimpleDateFormat SIMPLE_YEAR = new SimpleDateFormat("yy/M/d", Locale.getDefault());
  public final static SimpleDateFormat SECOND = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
  public final static SimpleDateFormat MINUTE_24 = new SimpleDateFormat("H:mm", Locale.getDefault());
  public final static SimpleDateFormat MINUTE_12 = new SimpleDateFormat("h:mm", Locale.getDefault());

  public final static Long MAX_MICROSECONDS = 10000000000000000L;
  public static long OFFSET = 0L;

  private static final int ONE_MINUTE = 60;
  private static final int ONE_HOUR = ONE_MINUTE * 60;
  private static final int ONE_DAY = ONE_HOUR * 24;
  private static final int ONE_WEEK = ONE_DAY * 7;
  private static final int ONE_MONTH = ONE_DAY * 30;
  private static final int ONE_YEAR = ONE_DAY * 365;

  public static void refreshOffset() {
    OFFSET = TimeZone.getDefault().getRawOffset();
  }

  public static String get(SimpleDateFormat format, Long ts) { return get(format, new Date(ts)); }
  public static String get(SimpleDateFormat format, Date date) { return format.format(date); }
  public static String get(Long ts) {
    if (ts == null) {
      return "";
    }

    Date date = new Date(ts);
    Date now = new Date(System.currentTimeMillis());

    if (DateUtils.isSameDay(now, date)) {
      return getTime(date);
    }

    Calendar cal1 = Calendar.getInstance();
    cal1.setTime(date);
    Calendar cal2 = Calendar.getInstance();
    cal2.setTime(now);

    int year1 = cal1.get(Calendar.YEAR) - 1900;
    int year2 = cal2.get(Calendar.YEAR) - 1900;

    if (year1 == year2) {
      return get(SIMPLE_DATE, date);
    }
    return get(FULL_DAY, date);
  }

  public static String getTime(Long ts) {
    if (ts == null || ts == 0L) {
      return "";
    }
    return getTime(new Date(ts));
  }

  public static String getTime(Date date) {
    /*
    if (DateFormat.is24HourFormat(ChannelPlugin.getContext())) {
      return getScript(MINUTE_24, date);
    }
    */

    Calendar cal = Calendar.getInstance();
    cal.setTime(date);

    String time = get(MINUTE_12, date);
    return String.format("%s%s", time, cal.get(Calendar.AM_PM) == Calendar.PM ? "pm" : "am");
  }

  public static String getFullYear(Long ts) {
    String date = TimeUtils.get(TimeUtils.SIMPLE_DAY, ts);
    String time = TimeUtils.getTime(ts);

    return String.format("%s %s", date, time);
  }

  public static String getResolveDuration(Context context, Long resolutionTime) {
    String first = context.getString(R.string.ch_user_chat_timer_one_min_less);
    String second = null;
    long remain;

    if (resolutionTime != null) {
      long min = resolutionTime / TimeUtils.ONE_MINUTE;
      if (min > 0) {
        first = context.getString(R.string.ch_user_chat_timer_min_ago, min);

        long hour = resolutionTime / TimeUtils.ONE_HOUR;
        if (hour > 0) {
          remain = (resolutionTime % TimeUtils.ONE_HOUR) / TimeUtils.ONE_MINUTE;

          second = (remain == 0) ? null : context.getString(R.string.ch_user_chat_timer_min_ago, remain);
          first = context.getString(R.string.ch_user_chat_timer_hour_ago, hour);

          long day = resolutionTime / TimeUtils.ONE_DAY;
          if (day > 0) {
            remain = (resolutionTime % TimeUtils.ONE_DAY) / TimeUtils.ONE_HOUR;

            second = (remain == 0) ? null : context.getString(R.string.ch_user_chat_timer_hour_ago, remain);
            first = context.getString(R.string.ch_user_chat_timer_day_ago, day);
          }
        }
      }
    }
    return TextUtils.isEmpty(second) ? first : String.format("%s %s", first, second);
  }
}
