package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

/**
 * Created by mika on 2016. 12. 9..
 */
public class ManagerMessageHolder extends ChatMessageHolder {
  Context context;
  AvatarLayout avatar;
  TextView textName;
  View actionFrame, actionButton;

  public ManagerMessageHolder(
      View itemView,
      OnMessageClickListener listener) {
    super(itemView, listener);

    context = itemView.getContext();
    avatar = (AvatarLayout) itemView.findViewById(R.id.message_avatar);
    textName = (TextView) itemView.findViewById(R.id.message_name);
    actionFrame = itemView.findViewById(R.id.chat_action_simple_frame);
    actionButton = itemView.findViewById(R.id.chat_action_simple);
  }

  protected void setProfile(ProfileEntity profile) {
    avatar.set(profile);
    if (profile == null) {
      textName.setText(ResUtils.getString(context, "ch.unknown"));
    } else {
      textName.setText(profile.getName());
    }
  }

  public void set(ChatMessageItem item, ProfileEntity profile, boolean isContext) {
    super.set(item.getMessage(), isContext);
    actionFrame.setVisibility(View.GONE);
    actionButton.setVisibility(View.GONE);
    setProfile(profile);
  }
}
