package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.etc.Typing;

import java.util.ArrayList;
import java.util.List;

public class TypingItem implements MessageItem {

  private List<Typing> typings;

  @Override
  public Long getFirst() {
    return Const.TIMESTAMP_MAX;
  }

  @Override
  public String getSecond() {
    return "TypingItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.TYPING;
  }

  public List<Typing> getTypings() {
    return typings;
  }

  public boolean hasTyping() {
    return typings != null && !typings.isEmpty();
  }

  public boolean hasMoreThanFour() {
    return typings != null && typings.size() >= 4;
  }

  public void addOrUpdateTyping(Typing typing) {
    if (typings == null) {
      typings = new ArrayList<>();
    }

    int index = typings.indexOf(typing);
    if (index >= 0) {
      typings.set(index, typing);
    } else {
      typings.add(typing);
    }
  }

  public void removeTyping(Typing typing) {
    if (typings == null) {
      return;
    }
    typings.remove(typing);
  }
}
