/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnActionMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnUserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.DateItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.QuestionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ActionMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.DateDividerHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ManagerMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.NewMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.QuestionMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SendingMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UserInfoMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UserMessageHolder;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.presenter.chat.ChatAdapterContract$Model;
import com.zoyi.channel.plugin.android.presenter.chat.ChatAdapterContract$View;
import com.zoyi.channel.plugin.android.presenter.chat.ChatContract$Presenter;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ChatAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ChatAdapterContract$Model,
ChatAdapterContract$View {
    private ChatContract$Presenter presenter;
    private SortedList<MessageItem> items = new SortedList(MessageItem.class, new SortedListCallback(this, false));
    private OnMessageClickListener onMessageClickListener;
    private OnActionMessageClickListener onActionMessageClickListener;
    private OnSendingMessageClickListener onSendingMessageClickListener;
    private OnUserInfoListener onOnUserInfoListener;

    public void setPresenter(ChatContract$Presenter chatContract$Presenter) {
        this.presenter = chatContract$Presenter;
    }

    @Override
    public void setOnMessageClickListener(OnMessageClickListener onMessageClickListener) {
        this.onMessageClickListener = onMessageClickListener;
    }

    @Override
    public void setOnActionMessageClickListener(OnActionMessageClickListener onActionMessageClickListener) {
        this.onActionMessageClickListener = onActionMessageClickListener;
    }

    @Override
    public void setOnSendingMessageClickListener(OnSendingMessageClickListener onSendingMessageClickListener) {
        this.onSendingMessageClickListener = onSendingMessageClickListener;
    }

    @Override
    public void setOnUserInfoListener(OnUserInfoListener onUserInfoListener) {
        this.onOnUserInfoListener = onUserInfoListener;
    }

    @Override
    public void addMessage(Message message, String string) {
        this.addMessages(Collections.singletonList(message), string);
    }

    @Override
    public void addMessages(List<Message> object, String string) {
        if (object == null) {
            return;
        }
        ArrayList<MessageItem> arrayList = new ArrayList<MessageItem>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Message)object.next();
            if (object2 == null || ((Message)object2).getLog() != null || !CompareUtils.isSame(string, ((Message)object2).getChatId())) continue;
            arrayList.add(new ChatMessageItem((Message)object2));
            arrayList.add(new DateItem(((Message)object2).getCreatedAt()));
            if (!CompareUtils.exists((Comparable)((Object)((Message)object2).getPersonType()), (Comparable[])new String[]{"User", "Veil"}) || (object2 = SendingMessageItem.create(((Message)object2).getRequestId(), ((Message)object2).getChannelId(), ((Message)object2).getChatId())) == null) continue;
            this.items.remove(object2);
        }
        this.items.addAll(arrayList);
    }

    @Override
    public void addMessageItem(MessageItem messageItem) {
        this.items.add((Object)messageItem);
    }

    @Override
    public void addMessageItems(Collection<MessageItem> collection) {
        this.items.addAll(collection);
    }

    @Override
    public void removeMessageItem(MessageItem messageItem) {
        this.items.remove((Object)messageItem);
    }

    @Override
    public MessageItem getItem(int n2) {
        if (n2 < 0 || n2 >= this.items.size()) {
            return null;
        }
        return (MessageItem)this.items.get(n2);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)viewGroup.getContext());
        MessageType messageType = MessageType.fromId(n2);
        switch (messageType) {
            case ACTION_MESSAGE: {
                return new ActionMessageHolder(layoutInflater.inflate(R.layout.ch_plugin_item_message_manager, viewGroup, false), this.onActionMessageClickListener);
            }
            case QUESTION_MESSAGE: {
                return new QuestionMessageHolder(layoutInflater.inflate(R.layout.ch_plugin_item_message_user, viewGroup, false), this.presenter.getBackColor(), this.presenter.getTextColor());
            }
            case MANAGER_MESSAGE: {
                return new ManagerMessageHolder(layoutInflater.inflate(R.layout.ch_plugin_item_message_manager, viewGroup, false), this.onMessageClickListener);
            }
            case SENDING: {
                return new SendingMessageHolder(layoutInflater.inflate(R.layout.ch_plugin_item_message_user, viewGroup, false), this.onSendingMessageClickListener, this.presenter.getBackColor(), this.presenter.getTextColor());
            }
            case USER_MESSAGE: {
                return new UserMessageHolder(layoutInflater.inflate(R.layout.ch_plugin_item_message_user, viewGroup, false), this.onMessageClickListener, this.presenter.getBackColor(), this.presenter.getTextColor());
            }
            case DATE: {
                return new DateDividerHolder(layoutInflater.inflate(R.layout.ch_plugin_item_message_date, viewGroup, false));
            }
            case NEW_MESSAGE_DIVIDER: {
                return new NewMessageHolder(layoutInflater.inflate(R.layout.ch_plugin_item_message_unread_divider, viewGroup, false));
            }
            case USER_INFO: {
                return new UserInfoMessageHolder(layoutInflater.inflate(R.layout.ch_plugin_item_message_user_info, viewGroup, false), this.onOnUserInfoListener);
            }
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n2) {
        MessageItem messageItem = (MessageItem)this.items.get(n2);
        switch (messageItem.getType()) {
            case ACTION_MESSAGE: {
                ActionMessageItem actionMessageItem = (ActionMessageItem)messageItem;
                viewHolder = (ActionMessageHolder)viewHolder;
                viewHolder.set(actionMessageItem);
                return;
            }
            case QUESTION_MESSAGE: {
                QuestionMessageItem questionMessageItem = (QuestionMessageItem)messageItem;
                viewHolder = (QuestionMessageHolder)viewHolder;
                viewHolder.set(questionMessageItem);
                return;
            }
            case MANAGER_MESSAGE: {
                messageItem = (ChatMessageItem)messageItem;
                viewHolder = (ManagerMessageHolder)viewHolder;
                viewHolder.set((ChatMessageItem)messageItem, this.presenter.getProfile(((ChatMessageItem)messageItem).getPersonType(), ((ChatMessageItem)messageItem).getPersonId()), ((ChatMessageItem)messageItem).isConnected(this.getItem(n2 - 1)));
                return;
            }
            case USER_MESSAGE: {
                messageItem = (ChatMessageItem)messageItem;
                viewHolder = (UserMessageHolder)viewHolder;
                viewHolder.set(((ChatMessageItem)messageItem).getMessage(), ((ChatMessageItem)messageItem).isConnected(this.getItem(n2 - 1)));
                return;
            }
            case SENDING: {
                SendingMessageItem sendingMessageItem = (SendingMessageItem)messageItem;
                viewHolder = (SendingMessageHolder)viewHolder;
                viewHolder.set(sendingMessageItem);
                return;
            }
            case DATE: {
                viewHolder = (DateDividerHolder)viewHolder;
                viewHolder.set((DateItem)messageItem);
                return;
            }
            case USER_INFO: {
                viewHolder = (UserInfoMessageHolder)viewHolder;
                viewHolder.set(this.presenter.getUserInfoItem());
            }
        }
    }

    public int getItemViewType(int n2) {
        return ((MessageItem)this.items.get(n2)).getType().toInt();
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public int getIndex(MessageItem messageItem) {
        return this.items.indexOf((Object)messageItem);
    }

    @Override
    public void setImageFilesToStorage() {
        PhotoAlbumStorage photoAlbumStorage = PhotoAlbumStorage.getInstance();
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            Object object = (MessageItem)this.items.get(i2);
            if (object.getType() != MessageType.MANAGER_MESSAGE && object.getType() != MessageType.USER_MESSAGE) continue;
            object = (ChatMessageItem)object;
            object = ((ChatMessageItem)object).getMessage();
            if ((object = ((Message)object).getFile()) == null || !((File)object).isImage() || TextUtils.isEmpty((CharSequence)((File)object).getUrl()) || TextUtils.isEmpty((CharSequence)((File)object).getFilename()) || ((File)object).getSize() <= 0L) continue;
            photoAlbumStorage.addImageFile((File)object);
        }
    }
}

