/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.splunk.mint.ActionEvent;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.ForegroundHandler$1;
import com.splunk.mint.ForegroundHandler$2;
import com.splunk.mint.ForegroundHandler$DataSwitchedToBackground;
import com.splunk.mint.LastPing;
import com.splunk.mint.SequentialExecutor;
import java.util.Calendar;
import java.util.TimeZone;

class ForegroundHandler {
    private static final SequentialExecutor executor = new SequentialExecutor();
    private static Application application;
    private static SharedPreferences preferences;
    private static SharedPreferences.Editor editor;
    private static final String LASTMINTTIMESTAMP = "LASTMINTTIMESTAMP";
    private static final String LASTMINTTIMESESSIONID = "LASTMINTTIMESESSIONID";

    ForegroundHandler() {
    }

    static void initialize(Application application) {
        if (ForegroundHandler.application == null) {
            ForegroundHandler.application = application;
        }
    }

    static void applicationMovedToBackground() {
        executor.getExecutor().submit(new ForegroundHandler$1());
    }

    static void activityResumed(Activity activity) {
        if (activity == null) {
            return;
        }
        executor.getExecutor().submit(new ForegroundHandler$2(activity));
    }

    private static synchronized void finalizeAndStartNewSession() {
        Object object = ForegroundHandler.getAndClearDataSwitchedToBackground();
        long l2 = ((ForegroundHandler$DataSwitchedToBackground)object).timeSwitchedToBackground;
        object = ((ForegroundHandler$DataSwitchedToBackground)object).sessionIdSwitchedToBackground;
        if (l2 == 0L || TextUtils.isEmpty((CharSequence)object)) {
            return;
        }
        long l3 = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L;
        long l4 = LastPing.getLastPingSentTime(application.getApplicationContext()) / 1000L;
        if (l4 > l2) {
            ActionEvent.createGnip(application.getApplicationContext(), l2, (String)object).save();
            return;
        }
        if (l3 - l2 > 300L) {
            ActionEvent.createGnip(application.getApplicationContext(), l2, (String)object).save();
            LastPing.setLastPingSentTime(application.getApplicationContext());
            ActionEvent.createPing().send(true);
        }
    }

    private static synchronized void setDataSwitchedToBackground() {
        ForegroundHandler.initPreferences(application.getApplicationContext());
        long l2 = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L;
        editor.putLong(LASTMINTTIMESTAMP, l2).putString(LASTMINTTIMESESSIONID, BaseDTO.getGlobalSessionID()).apply();
    }

    private static synchronized ForegroundHandler$DataSwitchedToBackground getAndClearDataSwitchedToBackground() {
        ForegroundHandler.initPreferences(application.getApplicationContext());
        Long l2 = preferences.getLong(LASTMINTTIMESTAMP, 0L);
        String string = preferences.getString(LASTMINTTIMESESSIONID, "");
        editor.putLong(LASTMINTTIMESTAMP, 0L).putString(LASTMINTTIMESESSIONID, "").apply();
        return new ForegroundHandler$DataSwitchedToBackground(l2, string);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static synchronized void initPreferences(Context context) {
        if (preferences == null) {
            preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        }
        if (editor == null) {
            editor = preferences.edit();
        }
    }

    static /* synthetic */ void access$000() {
        ForegroundHandler.setDataSwitchedToBackground();
    }

    static /* synthetic */ void access$100() {
        ForegroundHandler.finalizeAndStartNewSession();
    }
}

