package com.zoyi.channel.plugin.android.push;

import android.content.Context;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.ChannelException;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.OnCheckInListener;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.util.IntentUtils;

public class ChannelPushClient {

  public static void handlePushMessage(final Context context) {
    ChannelPushManager.clearNotification(context);

    if (PrefSupervisor.hasPushChatId(context) && CheckInPrefSupervisor.hasCheckInData(context)) {
      if (ChannelPlugin.isDataStored()) {
        launchChat(context);
      } else {
        if (ChannelPlugin.isInitialized()) {
          ChannelPlugin.checkIn(CheckInPrefSupervisor.get(context), new OnCheckInListener() {
            @Override
            public void onSuccessed() {
              launchChat(context);
            }

            @Override
            public void onFailed(ChannelException exception) {}
          });
        }
      }
    }
  }

  private static void launchChat(Context context) {
    String chatId = PrefSupervisor.getPushChatId(context);

    if (!TextUtils.isEmpty(chatId)) {
      IntentUtils.setNextActivity(context, ChatActivity.class)
          .putExtra(Const.EXTRA_CHAT_ID, chatId)
          .putExtra(Const.EXTRA_CHAT_COUNT, 0)
          .putExtra(Const.EXTRA_CHAT_EMPTY, true)
          .startActivity();
    }
    PrefSupervisor.clearPushChatId(context);
  }

}
