package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.UserChat;

public class CloseMessageItem implements MessageItem {

  private UserChat userChat;
  private long timestamp;

  public CloseMessageItem(UserChat userChat, long timestamp) {
    this.userChat = userChat;
    this.timestamp = timestamp;
  }

  @Override
  public Long getFirst() {
    return timestamp;
  }

  @Override
  public String getSecond() {
    return "CloseMessageItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.CLOSE;
  }

  public UserChat getUserChat() {
    return userChat;
  }
}
