package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.TimeUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChat implements ChannelModel, UpdatedModel {
  private String id;
  private String channelId;
  private String personType;
  private String personId;
  private String referId;
  private String state;
  private Long createdAt;
  private Long updatedAt;
  private Long followedAt;
  private Long resolvedAt;
  private String lastMessageId;
  private String openedAt;
  private Long notifiedAt;
  private Boolean alert;
  private Boolean unread;
  private List<String> talkedManagerIds;
  private String review;
  private String followedBy;
  private Long resolutionTime;

  public String getId() {
    return id;
  }

  public String getChannelId() {
    return channelId;
  }

  public String getPersonType() {
    return personType;
  }

  public String getPersonId() {
    return personId;
  }

  public String getReferId() {
    return referId;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public boolean isStateResolved() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_RESOLVED.equals(state);
  }

  public boolean isStateClosed() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_CLOSED.equals(state);
  }

  public boolean isStateCompleted() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_COMPLETED.contains(state);
  }

  public boolean isStateRemoved() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_REMOVED.equals(state);
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public Long getUpdatedAt() {
    return updatedAt;
  }

  public String getLastMessageId() {
    return lastMessageId;
  }

  public String getOpenedAt() {
    return openedAt;
  }

  public Long getNotifiedAt() {
    return notifiedAt;
  }

  public Boolean getAlert() {
    return alert;
  }

  public Boolean getUnread() {
    return unread;
  }

  public List<String> getTalkedManagerIds() {
    if (talkedManagerIds == null) {
      return new ArrayList<>();
    }
    return talkedManagerIds;
  }

  public String getReview() {
    return review;
  }

  public Long getFollowedAt() {
    return followedAt;
  }

  public Long getResolvedAt() {
    return resolvedAt;
  }

  public String getFollowedBy() {
    return followedBy;
  }

  public Long getResolutionTime() {
    return resolutionTime;
  }

  public String getResolutionDuration(Context context) {
    return TimeUtils.getResolveDuration(context, resolutionTime);
  }

  public String getSessionId() {
    return String.format("%s:%s", channelId, id);
  }

  public final static String CLASSNAME = "UserChat";
}
