package com.zoyi.channel.plugin.android;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by mika on 2017. 1. 24..
 */
public class CheckIn {
  public static CheckIn create() {
    return new CheckIn();
  }

  private String userId;
  private String name;
  private String avatarUrl;
  private String mobileNumber;
  private Map<String, Object> meta;

  public CheckIn() {
    meta = new HashMap<>();
  }

  public CheckIn withUserId(String userId) {
    this.userId = userId;
    return this;
  }

  public CheckIn withName(String name) {
    this.name = name;
    return this;
  }

  public CheckIn withAvatarUrl(String avatarUrl) {
    this.avatarUrl = avatarUrl;
    return this;
  }

  public CheckIn withMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
    return this;
  }

  public CheckIn withMeta(String key, Object value) {
    meta.put(key, value);
    return this;
  }

  public String getUserId() {
    return userId;
  }

  public String getName() {
    return name;
  }

  public String getAvatarUrl() {
    return avatarUrl;
  }

  public String getMobileNumber() {
    return mobileNumber;
  }

  public Map<String, Object> getMapMeta() {
    return meta;
  }

  public Object getMeta() {
    return meta;
  }
}
