package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimationListener;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.ActionType;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.MenuState;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mika on 9/28/16.
 */
public class BigBar extends LinearLayout {
  public BigBar(Context context) {
    super(context);
    init(context);
  }

  public BigBar(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public BigBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  public BigBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    super(context, attrs, defStyleAttr, defStyleRes);
    init(context);
  }

  private static final int MENU_BUTTON_WIDTH = 40;
  private static final int MENU_TEXT_WIDTH = 32;
  private static final int TITLE_LAYOUT_MARGIN = 16;

  RelativeLayout root;
  RelativeLayout layout;
  LinearLayout leftLayout;
  LinearLayout rightLayout;
  TextView textTitle;
  RelativeLayout titleLayout;
//  RelativeLayout layoutPush;
//  ChannelLayout channelLayout;
//  AvatarLayout avatarLayout;
//  TextView textPerson;
//  TextView textMessage;
//  RelativeLayout buttonClosePush;
  FrameLayout layoutAlert;
  TextView textAlert;

  private Context context;
  private BaseActivity activity;
  private Animation pushAnimation, alertAnimation;
  private boolean titleSelectable = false;
  private Map<Integer, TextView> textMap;
  private List<MenuButton> buttons;
  private int background = Color.BLACK, foreground = Color.WHITE;
  private boolean init = false;

  private void init(Context context) {
    this.context = context;
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_bigbar, this, true);
    root = (RelativeLayout) findViewById(R.id.layout_root);
    layout = (RelativeLayout) findViewById(R.id.bar_layout);
    leftLayout = (LinearLayout) findViewById(R.id.layout_left);
    rightLayout = (LinearLayout) findViewById(R.id.layout_right);
    textTitle = (TextView) findViewById(R.id.bar_title_main);
    titleLayout = (RelativeLayout) findViewById(R.id.layout_title);
//    layoutPush = (RelativeLayout) findViewById(R.id.bar_layout_push);
//    channelLayout = (ChannelLayout) findViewById(R.id.bar_layout_channel_push);
//    avatarLayout = (AvatarLayout) findViewById(R.id.bar_layout_avatar_push);
//    textPerson = (TextView) findViewById(R.id.bar_text_person);
//    textMessage = (TextView) findViewById(R.id.bar_text_message);
//    buttonClosePush = (RelativeLayout) findViewById(R.id.button_close_push);
//    layoutAlert = (FrameLayout) findViewById(R.id.bar_layout_alert);
//    textAlert = (TextView) findViewById(R.id.bar_text_alert);

//    buttonClosePush.setOnClickListener(new OnClickListener() {
//      @Override
//      public void onClick(View v) {
//        hidePush();
//      }
//    });
//
//    layoutPush.setOnClickListener(new OnClickListener() {
//      @Override
//      public void onClick(View v) {
////        if (chatEntity != null) {
////          SuperBus.getScript().post(new RedirectChatBus(chatEntity));
////          hidePush();
////        }
//      }
//    });

//    layoutAlert.setOnClickListener(new OnClickListener() {
//      @Override
//      public void onClick(View v) {
//        hideAlert();
//      }
//    });

    textMap = new HashMap<>();
    buttons = new ArrayList<>();
    pushAnimation = AnimationUtils.loadAnimation(getContext(), R.anim.ch_plugin_push);
    pushAnimation.setAnimationListener(new Animation.AnimationListener() {
      @Override
      public void onAnimationStart(android.view.animation.Animation animation) {
//        layoutPush.setVisibility(VISIBLE);
      }

      @Override
      public void onAnimationEnd(android.view.animation.Animation animation) {
//        hidePush();
      }

      @Override
      public void onAnimationRepeat(android.view.animation.Animation animation) {
      }
    });

    alertAnimation = AnimationUtils.loadAnimation(getContext(), R.anim.ch_plugin_alert);
    alertAnimation.setFillEnabled(true);
    alertAnimation.setAnimationListener(new SimpleAnimationListener() {
      @Override
      public void onAnimationStart(Animation animation) {
        layoutAlert.setVisibility(VISIBLE);
      }

      @Override
      public void onAnimationEnd(Animation animation) {
        hideAlert();
      }
    });
  }

  public BigBar withActivity(BaseActivity activity) {
    this.activity = activity;
    return this;
  }

  public BigBar addMenu(ActionType actionType, MenuPosition menuPosition) {
    return addMenu(actionType, menuPosition, MenuState.VISIBLE);
  }

  public BigBar addMenu(final ActionType actionType, MenuPosition menuPosition, MenuState menuState) {
    MenuButton menuButton = new MenuButton(context);
    menuButton.setAction(actionType);
    menuButton.setMenuPosition(menuPosition);
    menuButton.setOnTouchListener(new ButtonTouchHandler(menuButton));
    menuButton.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        eventRaised(actionType);
      }
    });
    setViewState(menuButton, menuState);
    addView(menuButton, menuPosition);
    buttons.add(menuButton);

    return this;
  }

  public BigBar addText(MenuPosition menuPosition) {
    return addText(0, menuPosition, "");
  }

  public BigBar addText(MenuPosition menuPosition, String string) {
    return addText(0, menuPosition, string);
  }

  private BigBar addText(int id, MenuPosition menuPosition, String string) {
    if (!textMap.containsKey(id)) {
      LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
          (int) Utils.dpToPx(context, 32),
          LayoutParams.WRAP_CONTENT);
      params.weight = 1.0f;
      params.leftMargin = MenuPosition.LEFT.equals(menuPosition) ? (int) Utils.dpToPx(context, 8) * -1 : 0;
      params.rightMargin = MenuPosition.RIGHT.equals(menuPosition) ? (int) Utils.dpToPx(context, 8) * -1 : 0;
      params.gravity = Gravity.CENTER_VERTICAL
          | (MenuPosition.LEFT.equals(menuPosition) ? Gravity.START : Gravity.END);

      TextView textView = new TextView(context);
      textView.setTypeface(textView.getTypeface(), Typeface.BOLD);
      textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 14);
      textView.setLayoutParams(params);
      textView.setText(string);

      textMap.put(id, textView);
      addView(textView, menuPosition);
    }
    return this;
  }

  public void setText(int number) {
    if (textMap.size() == 1) {
      setText(textMap.entrySet().iterator().next().getKey(), number);
    }
  }

  public void setText(int id, int number) {
    if (textMap.containsKey(id)) {
      textMap.get(id).setText(Utils.getCount(number, true));
    }
  }

  public void setMenuState(ActionType actionType, MenuState buttonState) {
    if (actionType == null) {
      return;
    }
    for (MenuButton menuButton : buttons) {
      if (actionType.equals(menuButton.getAction())) {
        setViewState(menuButton, buttonState);
      }
    }
  }

  public BigBar setTitle(String string) {
    textTitle.setText(string);
    return this;
  }

  public BigBar setTheme(int background, int foreground) {
    this.background = background;
    this.foreground = foreground;

    layout.setBackgroundColor(background);
    textTitle.setTextColor(foreground);

    for (TextView textView : textMap.values()) {
      textView.setTextColor(foreground);
    }
    for (MenuButton menuButton : buttons) {
      menuButton.setColor(foreground);
    }
    return this;
  }

  public BigBar setTitleSelectable() {
    textTitle.setPadding(0, 0, (int) Utils.dpToPx(context, 24), 0);
    titleSelectable = true;
    titleLayout.setOnTouchListener(new ButtonTouchHandler(titleLayout));

    return this;
  }

  public boolean isTitleSelectable() {
    return titleSelectable;
  }

  public void hide() {
    layout.setVisibility(GONE);
  }

  public void build() {
    if (init) { return; }
    init = true;

    if (foreground < 0 || background < 0) {
      if (activity != null) {
        background = activity.getBackgroundColor();
        foreground = activity.getTextColor();
      }
    }

    setTheme(background, foreground);

    setTitleLayoutMargin();
  }

  private void setViewState(View view, MenuState menuState) {
    if (menuState == null) {
      return;
    }

    switch (menuState) {
      case VISIBLE:
        view.setVisibility(VISIBLE);
        view.setAlpha(1.0f);
        view.setEnabled(true);
        break;

      case DISABLED:
        view.setVisibility(VISIBLE);
        view.setAlpha(0.3f);
        view.setEnabled(false);
        break;

      case HIDDEN:
        view.setVisibility(GONE);
        break;
    }
    setTitleLayoutMargin();
  }

  private int getMarginForTitle() {
    int left = TITLE_LAYOUT_MARGIN, right = TITLE_LAYOUT_MARGIN;

    if (textMap.size() > 0) {
      left += MENU_TEXT_WIDTH;
    }

    for (MenuButton button : buttons) {
      switch (button.getMenuPosition()) {
        case LEFT:
          if (button.isVisible()) {
            left += MENU_BUTTON_WIDTH;
          }
          break;

        case RIGHT:
          if (button.isVisible()) {
            right += MENU_BUTTON_WIDTH;
          }
          break;
      }
    }

    return (int) Math.max(Utils.dpToPx(context, left), Utils.dpToPx(context, right));
  }

  private void setTitleLayoutMargin() {
    int margin = getMarginForTitle();
    RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) titleLayout.getLayoutParams();

    layoutParams.leftMargin = margin;
    layoutParams.rightMargin = margin;

    titleLayout.setLayoutParams(layoutParams);
  }

  private void addView(View view, MenuPosition menuPosition) {
    if (MenuPosition.LEFT.equals(menuPosition)) {
      leftLayout.addView(view);
    } else {
      rightLayout.addView(view);
    }
  }

  private void eventRaised(ActionType actionType) {
    if (activity != null) {
      activity.optionClicked(actionType);
    }
  }

//  public void showPush(ChatEntity entity, ProfileEntity person, String message) {
//    if (entity == null) { return; }
//    this.chatEntity = entity;
//
//    Channel channel = RealmUtility.first(Channel.class, "id", entity.getChannelId());
//    channelLayout.set(channel);
//    textMessage.setText(Optional.ofNullable(message).orElse(""));
//
//    avatarLayout.set(person);
//    textPerson.setText(Optional.ofNullable(person)
//        .map(ProfileEntity::getName)
//        .orElse(App.getUnknown()));
//
//    layoutPush.setVisibility(VISIBLE);
//    layoutPush.startAnimation(pushAnimation);
//  }

//  public void hidePush() {
//    layoutPush.clearAnimation();
//    layoutPush.setVisibility(GONE);
////    this.chatEntity = null;
//  }

  public void showAlert(String message) {
    if (message != null) {
      textAlert.setText(message);
      layoutAlert.startAnimation(alertAnimation);
    }
  }

  public void hideAlert() {
    layoutAlert.clearAnimation();
    layoutAlert.setVisibility(GONE);
  }

  // internal class

  public enum  MenuPosition {
    LEFT, RIGHT
  }

  public class ButtonTouchHandler implements View.OnTouchListener {
    private float normal = 1.0f;
    private float pressed = 0.3f;

    public ButtonTouchHandler(View view) {
      view.setAlpha(normal);
    }

    public ButtonTouchHandler(View view, float normal, float pressed) {
      this.normal = normal;
      this.pressed = pressed;
      view.setAlpha(normal);
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
      if (v.isEnabled()) {
        switch (event.getAction()) {
          case MotionEvent.ACTION_DOWN:
            v.setAlpha(pressed);
            break;
          case MotionEvent.ACTION_UP:
          case MotionEvent.ACTION_CANCEL:
            v.setAlpha(normal);
            break;
        }
      }
      return false;
    }
  }
}
