package com.zoyi.channel.plugin.android.presenter.settings;

import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.presenter.BasePresenter;
import com.zoyi.channel.plugin.android.presenter.BaseView;

import java.util.List;

public interface ProfileEditContract {

  interface View extends BaseView<Presenter> {

    void onUpdateSuccessed();
    void onShowFailedMessage(String message);

    void onLoadedCountries(List<Country> countries);
  }

  interface Presenter extends BasePresenter<View> {

    void updateUserName(String name);
    void updateUserMobileNumber(String mobileNumber);

    void getCountries();
  }
}
