package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.util.draw.Display;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * Created by ryan on 2017. 8. 28..
 */

public class Event {

  private String name;
  private Map<String, Object> properties;
  private Map<String, Object> sysProperties;

  public Event(
      @Nullable Context context,
      @NonNull String name,
      @Nullable Map<String, Object> properties) {
    this.name = name;
    this.properties = properties;
    setSysProperties(context);
  }

  private void setSysProperties(Context context) {
    sysProperties = new HashMap<>();
    String pluginId = ChannelPlugin.getPluginId();
    if (!TextUtils.isEmpty(pluginId)) {
      sysProperties.put("pluginId", ChannelPlugin.getPluginId());
    }
    sysProperties.put("pluginVersion", BuildConfig.VERSION_NAME);
    sysProperties.put("screenWidth", Display.getWidth(context));
    sysProperties.put("screenHeight", Display.getHeight(context));
    sysProperties.put("os", String.format(Locale.US, "Android %d", Build.VERSION.SDK_INT));
    sysProperties.put("device", Build.MODEL);
  }
}
