/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatCheckListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatHolder;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

class UserChatListAdapter
extends RecyclerView.Adapter<UserChatHolder>
implements UserChatAdapterContract.View,
UserChatAdapterContract.Model {
    private OnUserChatClickListener clickListener;
    private OnUserChatCheckListener checkListener;
    private Map<String, UserChatItem> map = new HashMap<String, UserChatItem>();
    private UserChatListDataDictionary dictionary = new UserChatListDataDictionary();
    private SortedList<UserChatItem> items = new SortedList(UserChatItem.class, new SortedListCallback(this, true));
    private Queue<String> checkedChatIds = new LinkedList<String>();
    private boolean refreshBySocket = false;
    private boolean editMode = false;

    UserChatListAdapter() {
    }

    @Override
    public void setOnUserChatClickListener(OnUserChatClickListener clickListener) {
        this.clickListener = clickListener;
    }

    @Override
    public void setOnUserChatCheckListener(OnUserChatCheckListener checkListener) {
        this.checkListener = checkListener;
    }

    @Override
    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        this.notifyDataSetChanged();
    }

    @Override
    public void removeUserChat(String chatId) {
        if (this.map.containsKey(chatId)) {
            this.items.remove((Object)this.map.get(chatId));
        }
    }

    @Override
    public void checkUserChat(String chatId) {
        if (this.checkedChatIds.contains(chatId)) {
            this.removeCheckedChatId(chatId);
        } else {
            this.addCheckedChatId(chatId);
        }
    }

    private void removeCheckedChatId(String chatId) {
        this.checkedChatIds.remove(chatId);
        if (this.map.containsKey(chatId)) {
            int position = this.items.indexOf((Object)this.map.get(chatId));
            this.notifyItemChanged(position);
        }
    }

    private void addCheckedChatId(String chatId) {
        this.checkedChatIds.add(chatId);
        if (this.map.containsKey(chatId)) {
            int position = this.items.indexOf((Object)this.map.get(chatId));
            this.notifyItemChanged(position);
        }
    }

    @Override
    public void clear() {
        if (this.items != null) {
            this.items.clear();
        }
        if (this.map != null) {
            this.map.clear();
        }
        this.dictionary = new UserChatListDataDictionary();
    }

    @Override
    public void init(UserChatsWrapper wrapper) {
        this.dictionary.add(wrapper.getManagers());
        this.dictionary.add(wrapper.getSessions());
        this.dictionary.add(wrapper.getMessages());
        ArrayList<UserChatItem> delta = new ArrayList<UserChatItem>();
        for (UserChat userChat : wrapper.getUserChats()) {
            if (TextUtils.isEmpty((CharSequence)userChat.getLastMessageId())) continue;
            UserChatItem item = new UserChatItem(userChat, this.dictionary);
            if (this.map.containsKey(userChat.getId())) {
                this.items.remove((Object)this.map.get(userChat.getId()));
            }
            delta.add(item);
        }
        for (UserChatItem item : delta) {
            this.map.put(item.getId(), item);
        }
        this.items.clear();
        this.items.addAll(delta);
        this.refreshBySocket = true;
    }

    @Override
    public void stopRefreshBySocket() {
        this.refreshBySocket = false;
    }

    @Override
    public void clearCheckedChatId() {
        this.checkedChatIds.clear();
    }

    @Override
    public boolean hasCheckedChatIds() {
        return this.checkedChatIds.size() > 0;
    }

    @Override
    public String getCheckedChatId() {
        return this.checkedChatIds.poll();
    }

    @Override
    public void removeItem(UserChat userChat) {
        int position;
        String chatId;
        if (this.refreshBySocket && userChat != null && this.map.containsKey(chatId = userChat.getId()) && (position = this.items.indexOf((Object)this.map.get(chatId))) >= 0) {
            this.map.remove(chatId);
            this.items.removeItemAt(position);
        }
    }

    @Override
    public void updateItem(UserChatItem item) {
        int position;
        if (this.refreshBySocket && (position = this.items.indexOf((Object)item)) >= 0) {
            this.items.updateItemAt(position, (Object)item);
        }
    }

    @Override
    public void addOrUpdateItem(UserChat userChat) {
        if (this.refreshBySocket && userChat != null) {
            String chatId = userChat.getId();
            if (this.map.containsKey(chatId)) {
                UserChatItem item = this.map.get(chatId);
                item.setUserChat(userChat);
                this.updateItem(item);
            } else {
                UserChatItem item = new UserChatItem(userChat, this.dictionary);
                this.map.put(item.getId(), item);
                this.items.add((Object)item);
            }
        }
    }

    @Override
    public void updateDictionary(ChannelModel channelModel, boolean upsert) {
        if (this.refreshBySocket && channelModel != null) {
            if (upsert) {
                this.dictionary.add(channelModel);
            } else {
                this.dictionary.remove(channelModel);
            }
        }
    }

    public UserChatHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Context c = parent.getContext();
        View view = LayoutInflater.from((Context)c).inflate(R.layout.ch_plugin_item_user_chat, parent, false);
        return new UserChatHolder(view, this.clickListener, this.checkListener);
    }

    public void onBindViewHolder(UserChatHolder holder, int position) {
        holder.setUserChatItem((UserChatItem)this.items.get(position), this.checkedChatIds.contains(((UserChatItem)this.items.get(position)).getId()), this.editMode);
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public void updateManager(String managerId) {
        if (this.refreshBySocket) {
            for (int i = 0; i < this.items.size(); ++i) {
                UserChatItem item = (UserChatItem)this.items.get(i);
                if (!item.containsManager(managerId)) continue;
                this.items.updateItemAt(i, (Object)item);
            }
        }
    }

    @Override
    public void updateSession(Session session) {
        if (this.refreshBySocket && session != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                UserChatItem item = (UserChatItem)this.items.get(i);
                if (!item.getSessionId().equals(session.getId())) continue;
                item.setSession(session);
                this.items.updateItemAt(i, (Object)item);
                break;
            }
        }
    }
}

