/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings.edit;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.presenter.settings.ProfileEditContract;
import com.zoyi.channel.plugin.android.presenter.settings.ProfileEditPresenter;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import java.util.List;

public abstract class ProfileEditActivity
extends BaseActivity
implements View.OnClickListener,
EditTextChangedListener,
ProfileEditContract.View {
    protected TextView textLabel;
    protected TextView textCountryCode;
    protected TextView textDescription;
    protected WatchedEditText editText;
    protected ImageView imageDelete;
    protected ProfileEditContract.Presenter presenter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_profile_edit);
        Channel channel = ChannelStore.getChannel();
        Plugin plugin = ChannelStore.getPlugin();
        if (channel == null || plugin == null) {
            this.finish();
        }
        this.setBigBar(plugin);
        this.textLabel = (TextView)this.findViewById(R.id.tv_edit_label);
        this.textCountryCode = (TextView)this.findViewById(R.id.tv_edit_country_code);
        this.textDescription = (TextView)this.findViewById(R.id.tv_edit_description);
        this.editText = (WatchedEditText)this.findViewById(R.id.edit_profile_text);
        this.imageDelete = (ImageView)this.findViewById(R.id.iv_text_delete_all);
        this.imageDelete.setOnClickListener((View.OnClickListener)this);
        this.editText.setWatchedTextChangedListener(this);
        this.presenter = new ProfileEditPresenter((Context)this);
        this.presenter.setView(this);
    }

    private void setBigBar(Plugin plugin) {
        this.getBigBar().withActivity(this).addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.DONE, BigBar.MenuPosition.RIGHT).build();
        this.getBigBar().setMenuState(MenuButton.ActionType.DONE, MenuButton.MenuState.DISABLED);
        this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
        this.setStatusBarColor(plugin.getBackgroundColor());
    }

    protected void setBigBarTitle(String title) {
        this.getBigBar().setTitle(title);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.iv_text_delete_all) {
            this.editText.setText(null);
        }
    }

    @Override
    public void onUpdateSuccessed() {
        this.setResult(-1);
        this.finish();
    }

    @Override
    public void onShowFailedMessage(String message) {
        UIUtils.showAlertDialog((Context)this, message, this.getString(17039370), null, null, false, null);
    }

    @Override
    public void onLoadedCountries(List<Country> countries) {
    }

    protected abstract void setEditTextPadding(int var1);
}

