/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.photoview.gestures;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.MotionEvent;
import com.zoyi.channel.plugin.android.view.external.photoview.Compat;
import com.zoyi.channel.plugin.android.view.external.photoview.gestures.CupcakeGestureDetector;

@TargetApi(value=5)
public class EclairGestureDetector
extends CupcakeGestureDetector {
    private static final int INVALID_POINTER_ID = -1;
    private int mActivePointerId = -1;
    private int mActivePointerIndex = 0;

    public EclairGestureDetector(Context context) {
        super(context);
    }

    @Override
    float getActiveX(MotionEvent motionEvent) {
        try {
            return motionEvent.getX(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getX();
        }
    }

    @Override
    float getActiveY(MotionEvent motionEvent) {
        try {
            return motionEvent.getY(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getY();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction();
        switch (n2 & 0xFF) {
            case 0: {
                this.mActivePointerId = motionEvent.getPointerId(0);
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                n2 = Compat.getPointerIndex(motionEvent.getAction());
                int n3 = motionEvent.getPointerId(n2);
                if (n3 != this.mActivePointerId) break;
                n2 = n2 == 0 ? 1 : 0;
                this.mActivePointerId = motionEvent.getPointerId(n2);
                this.mLastTouchX = motionEvent.getX(n2);
                this.mLastTouchY = motionEvent.getY(n2);
            }
        }
        this.mActivePointerIndex = motionEvent.findPointerIndex(this.mActivePointerId != -1 ? this.mActivePointerId : 0);
        try {
            return super.onTouchEvent(motionEvent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
    }
}

