/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.animation.AnimationUtils;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Animator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.AnimatorSet;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ArgbEvaluator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ObjectAnimator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatorInflater {
    private static final int[] AnimatorSet = new int[]{16843490};
    private static final int AnimatorSet_ordering = 0;
    private static final int[] PropertyAnimator = new int[]{16843489};
    private static final int PropertyAnimator_propertyName = 0;
    private static final int[] Animator = new int[]{0x1010141, 16843160, 16843198, 16843199, 0x10101C0, 16843486, 16843487, 16843488};
    private static final int Animator_interpolator = 0;
    private static final int Animator_duration = 1;
    private static final int Animator_startOffset = 2;
    private static final int Animator_repeatCount = 3;
    private static final int Animator_repeatMode = 4;
    private static final int Animator_valueFrom = 5;
    private static final int Animator_valueTo = 6;
    private static final int Animator_valueType = 7;
    private static final int TOGETHER = 0;
    private static final int VALUE_TYPE_FLOAT = 0;

    public static Animator loadAnimator(Context object, int n2) throws Resources.NotFoundException {
        try (XmlResourceParser xmlResourceParser = null;){
            xmlResourceParser = object.getResources().getAnimation(n2);
            object = AnimatorInflater.createAnimatorFromXml(object, (XmlPullParser)xmlResourceParser);
            return object;
        }
    }

    private static Animator createAnimatorFromXml(Context context, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return AnimatorInflater.createAnimatorFromXml(context, xmlPullParser, Xml.asAttributeSet((XmlPullParser)xmlPullParser), null, 0);
    }

    private static Animator createAnimatorFromXml(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, AnimatorSet animatorSet, int n2) throws XmlPullParserException, IOException {
        int n3;
        Animator animator = null;
        ArrayList<ObjectAnimator> arrayList = null;
        int n4 = xmlPullParser.getDepth();
        while (((n3 = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n4) && n3 != 1) {
            if (n3 != 2) continue;
            String string2 = xmlPullParser.getName();
            if (string2.equals("objectAnimator")) {
                animator = AnimatorInflater.loadObjectAnimator(context, attributeSet);
            } else if (string2.equals("animator")) {
                animator = AnimatorInflater.loadAnimator(context, attributeSet, null);
            } else if (string2.equals("set")) {
                animator = new AnimatorSet();
                TypedArray typedArray = context.obtainStyledAttributes(attributeSet, AnimatorSet);
                TypedValue typedValue = new TypedValue();
                typedArray.getValue(0, typedValue);
                int n5 = typedValue.type == 16 ? typedValue.data : 0;
                AnimatorInflater.createAnimatorFromXml(context, xmlPullParser, attributeSet, (AnimatorSet)animator, n5);
                typedArray.recycle();
            } else {
                throw new RuntimeException("Unknown animator name: " + xmlPullParser.getName());
            }
            if (animatorSet == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ObjectAnimator>();
            }
            arrayList.add((ObjectAnimator)animator);
        }
        if (animatorSet != null && arrayList != null) {
            Animator[] animatorArray = new Animator[arrayList.size()];
            int n6 = 0;
            for (Animator animator2 : arrayList) {
                animatorArray[n6++] = animator2;
            }
            if (n2 == 0) {
                animatorSet.playTogether(animatorArray);
            } else {
                animatorSet.playSequentially(animatorArray);
            }
        }
        return animator;
    }

    private static ObjectAnimator loadObjectAnimator(Context context, AttributeSet object) throws Resources.NotFoundException {
        ObjectAnimator objectAnimator = new ObjectAnimator();
        AnimatorInflater.loadAnimator(context, object, objectAnimator);
        context = context.obtainStyledAttributes(object, PropertyAnimator);
        object = context.getString(0);
        objectAnimator.setPropertyName((String)object);
        context.recycle();
        return objectAnimator;
    }

    private static ValueAnimator loadAnimator(Context context, AttributeSet attributeSet, ValueAnimator valueAnimator) throws Resources.NotFoundException {
        int n2;
        int n3;
        attributeSet = context.obtainStyledAttributes(attributeSet, Animator);
        long l2 = attributeSet.getInt(1, 0);
        long l3 = attributeSet.getInt(2, 0);
        int n4 = attributeSet.getInt(7, 0);
        if (valueAnimator == null) {
            valueAnimator = new ValueAnimator();
        }
        n4 = n4 == 0 ? 1 : 0;
        TypedValue typedValue = attributeSet.peekValue(5);
        boolean bl = typedValue != null;
        int n5 = bl ? typedValue.type : 0;
        TypedValue typedValue2 = attributeSet.peekValue(6);
        boolean bl2 = typedValue2 != null;
        int n6 = n3 = bl2 ? typedValue2.type : 0;
        if (bl && n5 >= 28 && n5 <= 31 || bl2 && n3 >= 28 && n3 <= 31) {
            n4 = 0;
            valueAnimator.setEvaluator(new ArgbEvaluator());
        }
        if (n4 != 0) {
            if (bl) {
                float f2 = n5 == 5 ? attributeSet.getDimension(5, 0.0f) : attributeSet.getFloat(5, 0.0f);
                if (bl2) {
                    float f3 = n3 == 5 ? attributeSet.getDimension(6, 0.0f) : attributeSet.getFloat(6, 0.0f);
                    valueAnimator.setFloatValues(f2, f3);
                } else {
                    valueAnimator.setFloatValues(f2);
                }
            } else {
                float f4 = n3 == 5 ? attributeSet.getDimension(6, 0.0f) : attributeSet.getFloat(6, 0.0f);
                valueAnimator.setFloatValues(f4);
            }
        } else if (bl) {
            n4 = n5 == 5 ? (int)attributeSet.getDimension(5, 0.0f) : (n5 >= 28 && n5 <= 31 ? attributeSet.getColor(5, 0) : attributeSet.getInt(5, 0));
            if (bl2) {
                n5 = n3 == 5 ? (int)attributeSet.getDimension(6, 0.0f) : (n3 >= 28 && n3 <= 31 ? attributeSet.getColor(6, 0) : attributeSet.getInt(6, 0));
                valueAnimator.setIntValues(n4, n5);
            } else {
                valueAnimator.setIntValues(n4);
            }
        } else if (bl2) {
            n5 = n3 == 5 ? (int)attributeSet.getDimension(6, 0.0f) : (n3 >= 28 && n3 <= 31 ? attributeSet.getColor(6, 0) : attributeSet.getInt(6, 0));
            valueAnimator.setIntValues(n5);
        }
        valueAnimator.setDuration(l2);
        valueAnimator.setStartDelay(l3);
        if (attributeSet.hasValue(3)) {
            valueAnimator.setRepeatCount(attributeSet.getInt(3, 0));
        }
        if (attributeSet.hasValue(4)) {
            valueAnimator.setRepeatMode(attributeSet.getInt(4, 1));
        }
        if ((n2 = attributeSet.getResourceId(0, 0)) > 0) {
            valueAnimator.setInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)n2));
        }
        attributeSet.recycle();
        return valueAnimator;
    }
}

