/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.photo_picker.OnPhotoClickListener;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoHolder;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.presenter.photopicker.PhotoPickerAdapterContract;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import java.util.ArrayList;

class PhotoPickerAdapter
extends RecyclerView.Adapter<PhotoHolder>
implements PhotoPickerAdapterContract.View,
PhotoPickerAdapterContract.Model {
    private BaseActivity activity;
    private OnPhotoClickListener listener;
    private ArrayList<PhotoItem> photoItems;
    private ArrayList<PhotoItem> selectedItems;
    private int itemSize;
    private int itemMargin;

    PhotoPickerAdapter(BaseActivity activity) {
        this.activity = activity;
        this.photoItems = new ArrayList();
        this.selectedItems = new ArrayList();
        this.itemSize = Display.getWidth((Activity)activity) / 3;
        this.itemMargin = (int)Utils.dpToPx((Context)activity, 2.0f);
    }

    @Override
    public void setOnPhotoClickListener(OnPhotoClickListener listener) {
        this.listener = listener;
    }

    @Override
    public void notifyDataChanged() {
        this.notifyDataSetChanged();
    }

    public PhotoHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PhotoHolder(LayoutInflater.from((Context)this.activity).inflate(R.layout.ch_plugin_item_photo_picker, parent, false), this.activity.getBackgroundColor(), this.activity.getTextColor(), this.itemSize, this.itemMargin, this.listener);
    }

    public void onBindViewHolder(PhotoHolder holder, int position) {
        PhotoItem photoItem = this.photoItems.get(position);
        holder.setValue(photoItem, position, this.selectedItems.contains(photoItem));
    }

    public int getItemCount() {
        return this.photoItems.size();
    }

    @Override
    public void setPhotoItems(ArrayList<PhotoItem> photoItems) {
        this.photoItems = photoItems;
    }

    @Override
    public void refreshSelectedItems() {
        ArrayList<PhotoItem> removeItems = new ArrayList<PhotoItem>();
        for (PhotoItem selectedItem : this.selectedItems) {
            if (this.photoItems.contains(selectedItem)) continue;
            removeItems.add(selectedItem);
        }
        for (PhotoItem removeItem : removeItems) {
            this.selectedItems.remove(removeItem);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int selectPhotoItem(int position, boolean checked) {
        PhotoItem photoItem = this.photoItems.get(position);
        if (!checked) {
            this.selectedItems.remove(photoItem);
            return this.selectedItems.size();
        }
        if (this.selectedItems.size() < 20) {
            if (this.selectedItems.contains(photoItem)) return this.selectedItems.size();
            this.selectedItems.add(photoItem);
            return this.selectedItems.size();
        }
        Toast.makeText((Context)this.activity, (CharSequence)ResUtils.getString((Context)this.activity, "ch.photo.limit_alert"), (int)1).show();
        return -1;
    }

    @Override
    public int getSelectedItemCount() {
        return this.selectedItems.size();
    }

    @Override
    public ArrayList<String> getPhotoPaths() {
        ArrayList<String> photoPaths = new ArrayList<String>();
        for (PhotoItem photoItem : this.selectedItems) {
            photoPaths.add(photoItem.getPath());
        }
        return photoPaths;
    }
}

