/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import android.content.SharedPreferences;
import com.splunk.mint.Properties;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;

class UidManager {
    private static final String UID_PREFERENCES = "UIDPREFERENCES";
    private static final String UID_FIELD = "UID_FIELD";
    private static final String UID_ERROR_ID = "12345678901234567890123456789012";
    private static final String UID_NOSAVED = "UID_NOSAVED";
    private static final int UID_CORRECT_LENTH = 32;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    UidManager() {
    }

    protected static final String getUid(Context ctx) {
        SharedPreferences sharedPrefs;
        if (Properties.UID != null && Properties.UID.length() == 32) {
            return Properties.UID;
        }
        String uid = UID_ERROR_ID;
        if (ctx != null && (sharedPrefs = ctx.getSharedPreferences(UID_PREFERENCES, 0)) != null) {
            uid = sharedPrefs.getString(UID_FIELD, UID_NOSAVED);
        }
        if (uid.equals(UID_NOSAVED) || uid.equals(UID_ERROR_ID)) {
            uid = UidManager.generateUid();
            UidManager.saveUid(ctx, uid);
        }
        return uid;
    }

    protected static void saveUid(Context ctx, String uid) {
        if (uid != null && uid.length() == 32) {
            Properties.UID = uid;
            SharedPreferences sharedPrefs = ctx.getSharedPreferences(UID_PREFERENCES, 0);
            if (sharedPrefs != null) {
                sharedPrefs.edit().putString(UID_FIELD, uid).apply();
            }
        }
    }

    private static final String generateUid() {
        String s1 = Long.valueOf(new Date().getTime()).toString();
        String s2 = new Object().toString();
        long dat1 = System.nanoTime();
        String s3 = String.valueOf(dat1);
        String s4 = Integer.toString((int)(new Random(System.currentTimeMillis()).nextDouble() * 65535.0));
        String s5 = "android_id";
        String sall = s1 + s2 + s3 + s4 + "android_id";
        byte[] thedigest = null;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ee) {
                md = null;
            }
        }
        if (md != null) {
            try {
                byte[] bytesOfMessage = sall.getBytes("UTF-8");
                thedigest = md.digest(bytesOfMessage);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return new String(UidManager.encodeHex(thedigest));
        }
        return UID_ERROR_ID;
    }

    private static final char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }
}

