package com.zoyi.channel.plugin.android.model.source.userchat;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.activity.base.SortedItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.model.rest.*;

import java.util.*;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChatItem implements SortedItem {
  private UserChatListDataDictionary dictionary;
  private UserChat userChat;
  private Session session;
  private ReferMessage message;
  private Set<String> profiles;

  public UserChatItem(UserChat userChat, UserChatListDataDictionary dictionary) {
    this.userChat = userChat;
    this.dictionary = dictionary;
    this.message = dictionary.get(ReferMessage.class, userChat.getLastMessageId());
    this.session = dictionary.get(Session.class, userChat.getSessionId());
    this.profiles = new HashSet<>(userChat.getTalkedManagerIds());
  }

  public void setUserChat(UserChat userChat) {
    this.userChat = userChat;
    this.message = dictionary.get(ReferMessage.class, userChat.getLastMessageId());
    this.session = dictionary.get(Session.class, userChat.getSessionId());
    this.profiles = new HashSet<>(userChat.getTalkedManagerIds());
  }

  public Long getUpdatedAt() {
    if (userChat != null) {
      return userChat.getUpdatedAt();
    }
    return 0L;
  }

  public String getId() {
    if (userChat != null) {
      return userChat.getId();
    }
    return "";
  }

  public List<? extends ProfileEntity> getProfiles() {
    if (profiles == null || profiles.size() == 0) {
      return Collections.singletonList(ChannelStore.getChannel());
    }

    List<ProfileEntity> list = new ArrayList<>();
    for (String id : profiles) {
      list.add(dictionary.get(Manager.class, id));
    }
    return list;
  }

  public UserChat getUserChat() {
    return userChat;
  }

  public String getSessionId() {
    if (userChat != null) {
      return userChat.getSessionId();
    }
    return "";
  }

  public Session getSession() {
    return session;
  }

  public Message getMessage() {
    return message;
  }

  public boolean containsManager(String managerId) {
    return profiles != null && profiles.contains(managerId);
  }

  @Override
  public Long getFirst() {
    if (message != null) {
      return message.getCreatedAt();
    }
    return 0L;
  }

  @Override
  public String getSecond() {
    if (userChat != null) {
      return userChat.getId();
    }
    return "";
  }

  public void setSession(Session session) {
    this.session = session;
  }
}
