package com.zoyi.channel.plugin.android.activity.settings.edit;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.presenter.settings.ProfileEditContract;
import com.zoyi.channel.plugin.android.presenter.settings.ProfileEditPresenter;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

import java.util.List;

public abstract class ProfileEditActivity extends BaseActivity
    implements View.OnClickListener, EditTextChangedListener, ProfileEditContract.View {

  protected TextView textLabel, textCountryCode, textDescription;
  protected WatchedEditText editText;
  protected ImageView imageDelete;

  protected ProfileEditContract.Presenter presenter;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_profile_edit);

    Channel channel = ChannelStore.getChannel();
    Plugin plugin = ChannelStore.getPlugin();

    if (channel == null || plugin == null) {
      finish();
    }
    setBigBar(plugin);

    textLabel = (TextView) findViewById(R.id.tv_edit_label);
    textCountryCode = (TextView) findViewById(R.id.tv_edit_country_code);
    textDescription = (TextView) findViewById(R.id.tv_edit_description);
    editText = (WatchedEditText) findViewById(R.id.edit_profile_text);
    imageDelete = (ImageView) findViewById(R.id.iv_text_delete_all);
    imageDelete.setOnClickListener(this);

    editText.setWatchedTextChangedListener(this);

    presenter = new ProfileEditPresenter(this);
    presenter.setView(this);
  }

  private void setBigBar(Plugin plugin) {
    getBigBar().withActivity(this)
        .addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT)
        .addMenu(MenuButton.ActionType.DONE, BigBar.MenuPosition.RIGHT)
        .build();
    getBigBar().setMenuState(MenuButton.ActionType.DONE, MenuButton.MenuState.DISABLED);
    getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());

    setStatusBarColor(plugin.getBackgroundColor());
  }

  protected void setBigBarTitle(String title) {
    getBigBar().setTitle(title);
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();
    if (id == R.id.iv_text_delete_all) {
      editText.setText(null);
    }
  }

  @Override
  public void onUpdateSuccessed() {
    setResult(RESULT_OK);
    finish();
  }

  @Override
  public void onShowFailedMessage(String message) {
    UIUtils.showAlertDialog(this, message, getString(android.R.string.ok), null, null, false, null);
  }

  @Override
  public void onLoadedCountries(List<Country> countries) {}

  @Override
  public void setPresenter(ProfileEditContract.Presenter presenter) {}

  protected abstract void setEditTextPadding(int padding);
}
