/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.push.ChannelBroadcastReceiver;
import com.zoyi.channel.plugin.android.push.PushData;

public class NotificationFactory {
    static Notification createPushMessage(Context context, PushData pushData) {
        NotificationCompat.Builder builder = NotificationFactory.createBuilder(context, pushData);
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    private static NotificationCompat.Builder createBuilder(Context context, PushData pushData) {
        ComponentName componentName = new ComponentName(context, ChannelBroadcastReceiver.class);
        Intent clickIntent = new Intent("com.zoyi.channel.plugin.android.push.CHANNEL_PUSH_CLICK");
        clickIntent.setComponent(componentName);
        clickIntent.putExtra("host_app_intent", (Parcelable)NotificationFactory.getHostAppIntent(context, pushData));
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)999998, (Intent)clickIntent, (int)0x8000000);
        String title = context.getString(R.string.notification_title);
        String message = pushData.getMessage();
        if (TextUtils.isEmpty((CharSequence)message)) {
            return null;
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setSmallIcon(R.drawable.ch_push_icon).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.ch_push_large_icon)).setContentTitle((CharSequence)title).setContentText((CharSequence)message).setContentIntent(pendingIntent).setAutoCancel(true).setStyle((NotificationCompat.Style)NotificationFactory.getBigTextStyle(message)).setDefaults(-1);
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setCategory("msg").setPriority(1).setVisibility(1);
        }
        return builder;
    }

    private static Intent getHostAppIntent(Context context, PushData pushData) {
        Intent hostAppIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (hostAppIntent == null) {
            hostAppIntent = new Intent();
        } else {
            hostAppIntent.addCategory("android.intent.category.LAUNCHER");
            hostAppIntent.putExtra("chatId", pushData.getChatId());
        }
        return hostAppIntent;
    }

    private static NotificationCompat.BigTextStyle getBigTextStyle(String message) {
        return new NotificationCompat.BigTextStyle().bigText((CharSequence)message);
    }
}

