/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnActionMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ManagerMessageHolder;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class ActionMessageHolder
extends ManagerMessageHolder {
    private TextView simpleText;
    private ActionMessageItem item;

    public ActionMessageHolder(View itemView, final OnActionMessageClickListener listener) {
        super(itemView, null);
        this.simpleText = (TextView)itemView.findViewById(R.id.chat_action_simple_text);
        this.actionButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.actionMessageClicked(ActionMessageHolder.this.item);
                }
            }
        });
    }

    public void set(ActionMessageItem item) {
        super.set(item.getMessage(), false);
        if (!TextUtils.isEmpty((CharSequence)this.message.getMessage())) {
            this.text.setText((CharSequence)Html.fromHtml((String)this.message.getMessage()));
        }
        this.setProfile(ChannelStore.getChannel());
        this.item = item;
        if (item.getActionType() == null) {
            this.actionFrame.setVisibility(8);
            this.actionButton.setVisibility(8);
        } else {
            switch (item.getActionType()) {
                case REQUEST_WORKING_TIME: {
                    this.actionFrame.setVisibility(0);
                    this.actionButton.setVisibility(0);
                    this.simpleText.setText((CharSequence)ResUtils.getString(this.itemView.getContext(), "ch.out_of_work.confirm"));
                }
            }
        }
    }
}

