/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okio;

import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.ByteString;
import com.zoyi.retrofit2.okio.ForwardingSink;
import com.zoyi.retrofit2.okio.Segment;
import com.zoyi.retrofit2.okio.Sink;
import com.zoyi.retrofit2.okio.Util;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashingSink
extends ForwardingSink {
    private final MessageDigest messageDigest;

    public static HashingSink md5(Sink sink) {
        return new HashingSink(sink, "MD5");
    }

    public static HashingSink sha1(Sink sink) {
        return new HashingSink(sink, "SHA-1");
    }

    public static HashingSink sha256(Sink sink) {
        return new HashingSink(sink, "SHA-256");
    }

    private HashingSink(Sink sink, String algorithm) {
        super(sink);
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void write(Buffer source, long byteCount) throws IOException {
        int toHash;
        Util.checkOffsetAndCount(source.size, 0L, byteCount);
        Segment s = source.head;
        for (long hashedCount = 0L; hashedCount < byteCount; hashedCount += (long)toHash) {
            toHash = (int)Math.min(byteCount - hashedCount, (long)(s.limit - s.pos));
            this.messageDigest.update(s.data, s.pos, toHash);
            s = s.next;
        }
        super.write(source, byteCount);
    }

    public ByteString hash() {
        byte[] result = this.messageDigest.digest();
        return ByteString.of(result);
    }
}

