/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Single;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnErrorThrowable;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.plugins.RxJavaHooks;

public final class SingleOnSubscribeMap<T, R>
implements Single.OnSubscribe<R> {
    final Single<T> source;
    final Func1<? super T, ? extends R> transformer;

    public SingleOnSubscribeMap(Single<T> source, Func1<? super T, ? extends R> transformer) {
        this.source = source;
        this.transformer = transformer;
    }

    @Override
    public void call(SingleSubscriber<? super R> o) {
        MapSubscriber<? super T, ? extends R> parent = new MapSubscriber<T, R>(o, this.transformer);
        o.add(parent);
        this.source.subscribe(parent);
    }

    static final class MapSubscriber<T, R>
    extends SingleSubscriber<T> {
        final SingleSubscriber<? super R> actual;
        final Func1<? super T, ? extends R> mapper;
        boolean done;

        public MapSubscriber(SingleSubscriber<? super R> actual, Func1<? super T, ? extends R> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        public void onSuccess(T t) {
            R result;
            try {
                result = this.mapper.call(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause(ex, t));
                return;
            }
            this.actual.onSuccess(result);
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaHooks.onError(e);
                return;
            }
            this.done = true;
            this.actual.onError(e);
        }
    }
}

