/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.util.atomic.SpscAtomicArrayQueue;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class OperatorEagerConcatMap<T, R>
implements Observable.Operator<R, T> {
    final Func1<? super T, ? extends Observable<? extends R>> mapper;
    final int bufferSize;
    private final int maxConcurrent;

    public OperatorEagerConcatMap(Func1<? super T, ? extends Observable<? extends R>> mapper, int bufferSize, int maxConcurrent) {
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.maxConcurrent = maxConcurrent;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> t) {
        EagerOuterSubscriber<T, R> outer = new EagerOuterSubscriber<T, R>(this.mapper, this.bufferSize, this.maxConcurrent, t);
        outer.init();
        return outer;
    }

    static final class EagerInnerSubscriber<T>
    extends Subscriber<T> {
        final EagerOuterSubscriber<?, T> parent;
        final Queue<Object> queue;
        final NotificationLite<T> nl;
        volatile boolean done;
        Throwable error;

        public EagerInnerSubscriber(EagerOuterSubscriber<?, T> parent, int bufferSize) {
            this.parent = parent;
            AbstractQueue q = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue(bufferSize) : new SpscAtomicArrayQueue(bufferSize);
            this.queue = q;
            this.nl = NotificationLite.instance();
            this.request(bufferSize);
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(this.nl.next(t));
            this.parent.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.parent.drain();
        }

        void requestMore(long n) {
            this.request(n);
        }
    }

    static final class EagerOuterSubscriber<T, R>
    extends Subscriber<T> {
        final Func1<? super T, ? extends Observable<? extends R>> mapper;
        final int bufferSize;
        final Subscriber<? super R> actual;
        final Queue<EagerInnerSubscriber<R>> subscribers;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        final AtomicInteger wip;
        private EagerOuterProducer sharedProducer;

        public EagerOuterSubscriber(Func1<? super T, ? extends Observable<? extends R>> mapper, int bufferSize, int maxConcurrent, Subscriber<? super R> actual) {
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.actual = actual;
            this.subscribers = new LinkedList<EagerInnerSubscriber<R>>();
            this.wip = new AtomicInteger();
            this.request(maxConcurrent == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)maxConcurrent);
        }

        void init() {
            this.sharedProducer = new EagerOuterProducer(this);
            this.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    EagerOuterSubscriber.this.cancelled = true;
                    if (EagerOuterSubscriber.this.wip.getAndIncrement() == 0) {
                        EagerOuterSubscriber.this.cleanup();
                    }
                }
            }));
            this.actual.add(this);
            this.actual.setProducer(this.sharedProducer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() {
            ArrayList<EagerInnerSubscriber<R>> list;
            Queue<EagerInnerSubscriber<R>> queue = this.subscribers;
            synchronized (queue) {
                list = new ArrayList<EagerInnerSubscriber<R>>(this.subscribers);
                this.subscribers.clear();
            }
            for (Subscription subscription : list) {
                subscription.unsubscribe();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            Observable<R> observable;
            try {
                observable = this.mapper.call(t);
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, this.actual, t);
                return;
            }
            if (this.cancelled) {
                return;
            }
            EagerInnerSubscriber inner = new EagerInnerSubscriber(this, this.bufferSize);
            Queue<EagerInnerSubscriber<R>> queue = this.subscribers;
            synchronized (queue) {
                if (this.cancelled) {
                    return;
                }
                this.subscribers.add(inner);
            }
            if (this.cancelled) {
                return;
            }
            observable.unsafeSubscribe(inner);
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            EagerOuterProducer requested = this.sharedProducer;
            Subscriber<R> actualSubscriber = this.actual;
            NotificationLite nl = NotificationLite.instance();
            while (true) {
                boolean empty;
                EagerInnerSubscriber<R> innerSubscriber;
                if (this.cancelled) {
                    this.cleanup();
                    return;
                }
                boolean outerDone = this.done;
                Queue<EagerInnerSubscriber<R>> queue = this.subscribers;
                synchronized (queue) {
                    innerSubscriber = this.subscribers.peek();
                }
                boolean bl = empty = innerSubscriber == null;
                if (outerDone) {
                    Throwable error = this.error;
                    if (error != null) {
                        this.cleanup();
                        actualSubscriber.onError(error);
                        return;
                    }
                    if (empty) {
                        actualSubscriber.onCompleted();
                        return;
                    }
                }
                if (!empty) {
                    long requestedAmount = requested.get();
                    long emittedAmount = 0L;
                    Queue<Object> innerQueue = innerSubscriber.queue;
                    boolean innerDone = false;
                    while (true) {
                        outerDone = innerSubscriber.done;
                        Object v = innerQueue.peek();
                        boolean bl2 = empty = v == null;
                        if (outerDone) {
                            Throwable innerError = innerSubscriber.error;
                            if (innerError != null) {
                                this.cleanup();
                                actualSubscriber.onError(innerError);
                                return;
                            }
                            if (empty) {
                                Queue<EagerInnerSubscriber<R>> queue2 = this.subscribers;
                                synchronized (queue2) {
                                    this.subscribers.poll();
                                }
                                innerSubscriber.unsubscribe();
                                innerDone = true;
                                this.request(1L);
                                break;
                            }
                        }
                        if (empty || requestedAmount == emittedAmount) break;
                        innerQueue.poll();
                        try {
                            actualSubscriber.onNext(nl.getValue(v));
                        }
                        catch (Throwable ex) {
                            Exceptions.throwOrReport(ex, actualSubscriber, v);
                            return;
                        }
                        ++emittedAmount;
                    }
                    if (emittedAmount != 0L) {
                        if (requestedAmount != Long.MAX_VALUE) {
                            BackpressureUtils.produced(requested, emittedAmount);
                        }
                        if (!innerDone) {
                            innerSubscriber.requestMore(emittedAmount);
                        }
                    }
                    if (innerDone) continue;
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            }
        }
    }

    static final class EagerOuterProducer
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = -657299606803478389L;
        final EagerOuterSubscriber<?, ?> parent;

        public EagerOuterProducer(EagerOuterSubscriber<?, ?> parent) {
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalStateException("n >= 0 required but it was " + n);
            }
            if (n > 0L) {
                BackpressureUtils.getAndAddRequest(this, n);
                this.parent.drain();
            }
        }
    }
}

