/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Completable;
import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Single;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func1;

public final class CompletableFlatMapSingleToCompletable<T>
implements Completable.OnSubscribe {
    final Single<T> source;
    final Func1<? super T, ? extends Completable> mapper;

    public CompletableFlatMapSingleToCompletable(Single<T> source, Func1<? super T, ? extends Completable> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public void call(CompletableSubscriber t) {
        SourceSubscriber<? super T> parent = new SourceSubscriber<T>(t, this.mapper);
        t.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class SourceSubscriber<T>
    extends SingleSubscriber<T>
    implements CompletableSubscriber {
        final CompletableSubscriber actual;
        final Func1<? super T, ? extends Completable> mapper;

        public SourceSubscriber(CompletableSubscriber actual, Func1<? super T, ? extends Completable> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        public void onSuccess(T value) {
            Completable c;
            try {
                c = this.mapper.call(value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.onError(ex);
                return;
            }
            if (c == null) {
                this.onError(new NullPointerException("The mapper returned a null Completable"));
                return;
            }
            c.subscribe(this);
        }

        @Override
        public void onError(Throwable error) {
            this.actual.onError(error);
        }

        @Override
        public void onCompleted() {
            this.actual.onCompleted();
        }

        @Override
        public void onSubscribe(Subscription d) {
            this.add(d);
        }
    }
}

