/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal;

import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.ForwardingSink;
import com.zoyi.retrofit2.okio.Sink;
import java.io.IOException;

class FaultHidingSink
extends ForwardingSink {
    private boolean hasErrors;

    public FaultHidingSink(Sink delegate) {
        super(delegate);
    }

    public void write(Buffer source, long byteCount) throws IOException {
        if (this.hasErrors) {
            source.skip(byteCount);
            return;
        }
        try {
            super.write(source, byteCount);
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException(e);
        }
    }

    public void flush() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException(e);
        }
    }

    public void close() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.close();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException(e);
        }
    }

    protected void onException(IOException e) {
    }
}

