/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.presenter.chat;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.ColorRes;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat.CountryDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnActionMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageReviewListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnUserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.activity.chat.model.NewMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.QuestionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ResolveMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ActionType;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.chat.ChatState;
import com.zoyi.channel.plugin.android.event.ChannelModelBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserVeilWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.presenter.chat.ChatAdapterContract;
import com.zoyi.channel.plugin.android.presenter.chat.ChatContract;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ChatPresenter
implements ChatContract.Presenter,
OnActionMessageClickListener,
OnSendingMessageClickListener,
OnMessageClickListener,
OnUserInfoListener,
OnMessageSendListener,
OnMessageReviewListener {
    private ChatContract.View view;
    private ChatAdapterContract.View adapterView;
    private ChatAdapterContract.Model adapterModel;
    private Context context;
    private ProgressDialog dialog;
    private UserChat userChat;
    private Session session;
    private ChatDataDictionary dictionary;
    private CountryDictionary countryDictionary;
    private String chatId;
    private int backColor = -16777216;
    private int textColor = -1;
    private ChatState state = ChatState.IDLE;
    private String backwardId = "zzzzzzzzzzzzzzzz";
    private String forwardId = "0000000000000000";
    private String forwardTempId = "0000000000000000";
    private Long forwardTimestamp = Long.MIN_VALUE;
    private int fetchCounter = 0;
    private boolean welcomeMessageExists = false;
    private boolean backwardLoading = false;
    private boolean newMessageDismiss = false;
    private boolean firstMessage = true;
    private boolean isUserInfoFirst = true;
    private boolean isStateCompleted = false;
    private Long lastReadAt;
    private UserInfoItem userInfoItem;
    private List<SendingMessageItem> tempQueue;

    public ChatPresenter(Context context) {
        this.context = context;
        TimeUtils.refreshOffset();
        this.dictionary = new ChatDataDictionary();
        this.countryDictionary = new CountryDictionary(context);
        this.tempQueue = new ArrayList<SendingMessageItem>();
    }

    @Override
    public void showProgress() {
        if (this.dialog == null || !this.dialog.isShowing()) {
            this.dialog = ProgressHelper.show(this.context, ResUtils.getString(this.context, "ch.loading_information"));
        }
    }

    @Override
    public void hideProgress() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    @Override
    public void setView(ChatContract.View view) {
        this.view = view;
    }

    @Override
    public String getChatId() {
        return this.chatId;
    }

    @Override
    public boolean isStateCompleted() {
        return this.isStateCompleted;
    }

    @Override
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @Override
    public int getBackColor() {
        return this.backColor;
    }

    @Override
    public int getTextColor() {
        return this.textColor;
    }

    @Override
    public void setColor(@ColorRes int backColor, @ColorRes int textColor) {
        this.backColor = backColor;
        this.textColor = textColor;
    }

    @Override
    public void setAdapterView(ChatAdapterContract.View adapterView) {
        this.adapterView = adapterView;
        this.adapterView.setOnMessageClickListener(this);
        this.adapterView.setOnActionMessageClickListener(this);
        this.adapterView.setOnSendingMessageClickListener(this);
        this.adapterView.setOnUserInfoListener(this);
        this.adapterView.setOnMessageReviewListener(this);
    }

    @Override
    public void setAdapterModel(ChatAdapterContract.Model adapterModel) {
        this.adapterModel = adapterModel;
    }

    @Override
    public void init() {
        if (this.chatId == null) {
            this.addWelcomeMessage();
        } else {
            this.adapterModel.addMessageItems(this.getChatManager().getFailedItems(this.chatId));
            this.fetchUserChat();
        }
    }

    private void addWorkingTimeMessage() {
        String message;
        if (!(this.welcomeMessageExists || this.isStateCompleted || ChannelStore.isWorking() || TextUtils.isEmpty((CharSequence)(message = ChannelStore.getScript("out_of_work", "ch.scripts.out_of_work.default"))))) {
            this.welcomeMessageExists = true;
            this.adapterModel.addMessageItem(new ActionMessageItem(ActionType.REQUEST_WORKING_TIME, message, this.forwardTimestamp, 1));
        }
    }

    private void addWelcomeMessage() {
        if (!this.welcomeMessageExists) {
            if (!ChannelStore.isWorking()) {
                this.addWorkingTimeMessage();
            } else {
                String message;
                User user = ChannelStore.getUser();
                if (user != null && user.getName() != null) {
                    message = ChannelStore.getScript("welcome_user", "ch.scripts.welcome_user.default");
                    if (message != null) {
                        message = message.replace("${user}", user.getName());
                    }
                } else {
                    message = ChannelStore.getScript("welcome_veil", "ch.scripts.welcome_veil.default");
                }
                if (!TextUtils.isEmpty((CharSequence)message)) {
                    this.welcomeMessageExists = true;
                    this.adapterModel.addMessageItem(new ActionMessageItem(null, message, this.forwardTimestamp, 1));
                }
            }
        }
    }

    @Override
    public void fetchUserChat() {
        if (this.userChat == null) {
            this.showProgress();
        }
        this.setState(ChatState.USER_CHAT_LOADING, false);
        ChannelPlugin.getApi().getUserChat(this.chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserChatWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ChatPresenter.this.hideProgress();
                ChatPresenter.this.handleUserChatFetchError(error);
            }

            @Override
            public void onNext(UserChatWrapper userChatWrapper) {
                ChatPresenter.this.setUserChat(userChatWrapper, false);
            }
        });
    }

    private void createUserChat() {
        this.showProgress();
        this.setState(ChatState.USER_CHAT_LOADING, false);
        if (ChannelStore.getPluginId() != null) {
            ChannelPlugin.getApi().createUserChat(ChannelStore.getPluginId()).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    ChatPresenter.this.hideProgress();
                    ChatPresenter.this.handleUserChatFetchError(error);
                }

                @Override
                public void onNext(UserChatWrapper userChatWrapper) {
                    RxBus.post(new ChannelModelBus(userChatWrapper.getUserChat(), true));
                    RxBus.post(new ChannelModelBus(userChatWrapper.getSession(), true));
                    ChatPresenter.this.setUserChat(userChatWrapper, true);
                }
            });
        } else {
            this.hideProgress();
        }
    }

    private void setUserChat(UserChatWrapper wrapper, boolean create) {
        this.hideProgress();
        if (this.isStateEquals(ChatState.USER_CHAT_LOADING)) {
            if (wrapper == null) {
                this.handleUserChatFetchError(new Exception("UserChatWrapper cannot be null"));
            } else {
                this.userChat = wrapper.getUserChat();
                this.chatId = this.userChat.getId();
                this.isStateCompleted = this.userChat.isStateCompleted();
                this.session = wrapper.getSession();
                this.dictionary.add(wrapper.getManagers());
                this.adapterModel.setUserChat(this.userChat);
                this.view.onLoadUserChat();
                this.view.setInputLayoutVisibility();
                this.view.setReconnectVisibility(false);
                if (this.lastReadAt == null) {
                    this.lastReadAt = create ? Long.MAX_VALUE : this.session.getLastReadAt();
                }
                if (this.tempQueue.size() > 0) {
                    this.getChatManager().send(this.chatId, this.tempQueue, this);
                    this.tempQueue.clear();
                }
                this.joinChat();
            }
        }
    }

    private void handleUserChatFetchError(Throwable throwable) {
        if (throwable != null) {
            L.e(throwable.getMessage());
        }
        if (this.isStateEquals(ChatState.USER_CHAT_LOADING)) {
            this.setState(ChatState.USER_CHAT_NOT_LOADED, true);
        }
    }

    private void joinChat() {
        if (SocketManager.isReady()) {
            this.setState(ChatState.CHAT_JOINING, false);
            SocketManager.joinChat(this.chatId);
        } else {
            this.setState(ChatState.WAITING_SOCKET, false);
            SocketManager.reconnect();
        }
    }

    private boolean isMessageExists() {
        return CompareUtils.compare(this.backwardId, this.forwardId) < 0;
    }

    private boolean isAvailableRequest(int count) {
        return this.isStateEquals(ChatState.MESSAGES_LOADING) && this.fetchCounter == count;
    }

    @Override
    public void fetchMessages() {
        if (SocketManager.isReady()) {
            ++this.fetchCounter;
            this.setState(ChatState.MESSAGES_LOADING, false);
            if (!this.isMessageExists()) {
                this.fetchInitMessages(this.fetchCounter);
            } else {
                this.fetchForwardMessages(this.forwardId, this.fetchCounter);
            }
        } else {
            this.setState(ChatState.WAITING_SOCKET, false);
            SocketManager.reconnect();
        }
    }

    @Override
    public void fetchInitMessages(final int counter) {
        ChannelPlugin.getApi().getMessages(this.chatId, "zzzzzzzzzzzzzzzz", 30, "DESC").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<MessagesWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                if (ChatPresenter.this.isAvailableRequest(counter)) {
                    ChatPresenter.this.handleMessagesFetchError(error, counter);
                }
            }

            @Override
            public void onNext(MessagesWrapper wrapper) {
                if (ChatPresenter.this.isAvailableRequest(counter)) {
                    if (wrapper == null) {
                        ChatPresenter.this.handleMessagesFetchError(new Exception("MessagesWrapper cannot be null"), counter);
                    } else {
                        ChatPresenter.this.backwardId = wrapper.getNext();
                        ChatPresenter.this.dictionary.add(wrapper.getManagers());
                        ChatPresenter.this.dictionary.add(wrapper.getBots());
                        ChatPresenter.this.addMessages(wrapper.getMessages());
                        ChatPresenter.this.calculateForwardId(wrapper.getMessages());
                        ChatPresenter.this.calculateForwardId();
                        if (ChatPresenter.this.lastReadAt >= ChatPresenter.this.forwardTimestamp) {
                            ChatPresenter.this.lastReadAt = Long.MAX_VALUE;
                        }
                        ChatPresenter.this.addNewMessageItem(wrapper.getMessages());
                        ChatPresenter.this.addWorkingTimeMessage();
                        ChatPresenter.this.setState(ChatState.CHAT_READY, false);
                        ChatPresenter.this.readAll();
                        ChatPresenter.this.view.scrollToBottom(true);
                    }
                }
            }
        });
    }

    @Override
    public void fetchBackwardMessages() {
        if (this.backwardLoading || !this.isMessageExists()) {
            return;
        }
        this.backwardLoading = true;
        ChannelPlugin.getApi().getMessages(this.chatId, this.backwardId, 30, "DESC").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<MessagesWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ChatPresenter.this.backwardLoading = false;
                ChatPresenter.this.handleMessagesFetchError(error, ChatPresenter.this.fetchCounter);
            }

            @Override
            public void onNext(MessagesWrapper wrapper) {
                if (wrapper == null) {
                    ChatPresenter.this.handleMessagesFetchError(new Exception("MessagesWrapper cannot be null"), ChatPresenter.this.fetchCounter);
                } else {
                    ChatPresenter.this.backwardId = wrapper.getNext();
                    ChatPresenter.this.dictionary.add(wrapper.getManagers());
                    ChatPresenter.this.dictionary.add(wrapper.getBots());
                    ChatPresenter.this.adapterModel.addMessages(wrapper.getMessages(), ChatPresenter.this.chatId);
                    ChatPresenter.this.addNewMessageItem(wrapper.getMessages());
                }
                ChatPresenter.this.backwardLoading = false;
            }
        });
    }

    @Override
    public void fetchForwardMessages(String since, final int counter) {
        ChannelPlugin.getApi().getMessages(this.chatId, since, 30, "ASC").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<MessagesWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                if (ChatPresenter.this.isAvailableRequest(counter)) {
                    ChatPresenter.this.handleMessagesFetchError(error, counter);
                }
            }

            @Override
            public void onNext(MessagesWrapper wrapper) {
                if (ChatPresenter.this.isAvailableRequest(counter)) {
                    if (wrapper == null) {
                        ChatPresenter.this.handleMessagesFetchError(new Exception("MessagesWrapper cannot be null"), counter);
                    } else {
                        ChatPresenter.this.dictionary.add(wrapper.getManagers());
                        ChatPresenter.this.dictionary.add(wrapper.getBots());
                        ChatPresenter.this.addMessages(wrapper.getMessages());
                        ChatPresenter.this.calculateForwardId(wrapper.getMessages());
                        if (wrapper.getNext() == null) {
                            ChatPresenter.this.calculateForwardId();
                            ChatPresenter.this.setState(ChatState.CHAT_READY, false);
                            ChatPresenter.this.readAll();
                        } else {
                            ChatPresenter.this.fetchForwardMessages(ChatPresenter.this.forwardId, counter);
                        }
                    }
                }
            }
        });
    }

    private void handleMessagesFetchError(Throwable throwable, int counter) {
        if (throwable != null) {
            L.e(throwable.getMessage());
        }
        if (this.isStateEquals(ChatState.MESSAGES_LOADING) && this.fetchCounter == counter) {
            this.setState(ChatState.MESSAGES_NOT_LOADED, true);
        }
    }

    @Override
    public void calculateNewToast(int index) {
        if (this.lastReadAt == null || this.newMessageDismiss) {
            return;
        }
        MessageItem item = this.adapterModel.getItem(index);
        if (item != null) {
            if (this.lastReadAt < item.getFirst()) {
                this.view.setToastVisibility(true);
            } else {
                this.hideNewToast();
            }
        }
    }

    @Override
    public void newToastClicked() {
        if (this.lastReadAt != null) {
            NewMessageItem item = new NewMessageItem(this.lastReadAt);
            int index = this.adapterModel.getIndex(item);
            if (index < 0) {
                this.view.scrollTo(0);
            } else {
                this.hideNewToast();
                this.view.scrollTo(index);
            }
        }
    }

    @Override
    public void hideNewToast() {
        this.newMessageDismiss = true;
        this.view.setToastVisibility(false);
    }

    private void addNewMessageItem(List<Message> messages) {
        if (this.lastReadAt == null || this.isStateCompleted) {
            return;
        }
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        if (messages != null) {
            for (Message message : messages) {
                if (message.getLog() != null) continue;
                min = Math.min(min, message.getCreatedAt());
                max = Math.max(max, message.getCreatedAt());
            }
        }
        if (min <= this.lastReadAt && this.lastReadAt < max) {
            this.adapterModel.addMessageItem(new NewMessageItem(this.lastReadAt));
        }
    }

    private void addMessage(Message message) {
        if (CompareUtils.isSame(message.getChatId(), this.chatId)) {
            this.adapterModel.addMessage(message, this.chatId);
            boolean isMine = CompareUtils.exists((Comparable)((Object)message.getPersonType()), (Comparable[])new String[]{"User", "Veil"});
            if (this.isStateEquals(ChatState.CHAT_READY)) {
                this.calculateForwardId(message);
                this.readAll();
            } else {
                this.forwardTempId = CompareUtils.max(this.forwardTempId, message.getId());
            }
            this.forwardTimestamp = Math.max(this.forwardTimestamp, message.getCreatedAt());
            if (!this.isStateCompleted && this.firstMessage && isMine) {
                this.firstMessage = false;
                this.checkRequireUserInfo(this.forwardTimestamp);
            }
            this.view.scrollToBottom(isMine);
        }
    }

    private void addMessages(List<Message> messages) {
        if (messages != null) {
            for (Message message : messages) {
                this.forwardTimestamp = Math.max(this.forwardTimestamp, message.getCreatedAt());
                this.forwardId = CompareUtils.max(this.forwardId, message.getId());
            }
        }
        this.adapterModel.addMessages(messages, this.chatId);
    }

    private void calculateForwardId(Message message) {
        if (message != null) {
            this.forwardId = CompareUtils.max(this.forwardId, message.getId());
        }
    }

    private void calculateForwardId(List<Message> messages) {
        if (messages != null) {
            for (Message message : messages) {
                this.calculateForwardId(message);
            }
        }
    }

    private void calculateForwardId() {
        this.forwardId = CompareUtils.max(this.forwardId, this.forwardTempId);
    }

    @Override
    public void sendTextMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        SendingMessageItem item = new SendingMessageItem(this.chatId, message, false);
        this.adapterModel.addMessageItem(item);
        this.sendMessages(Collections.singletonList(item));
    }

    @Override
    public void sendImageFiles(ArrayList<String> imagePaths) {
        ArrayList<SendingMessageItem> items = new ArrayList<SendingMessageItem>();
        if (imagePaths != null) {
            for (String p : imagePaths) {
                SendingMessageItem item = new SendingMessageItem(this.chatId, p, true);
                this.adapterModel.addMessageItem(item);
                items.add(item);
            }
        }
        this.sendMessages(items);
    }

    private void sendMessages(List<SendingMessageItem> items) {
        this.view.scrollToBottom(true);
        if (this.chatId == null) {
            this.tempQueue.addAll(items);
            this.createUserChat();
        } else {
            this.getChatManager().send(items, (OnMessageSendListener)this);
        }
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean upsert) {
        if (channelModel != null && !TextUtils.isEmpty((CharSequence)this.chatId)) {
            switch (channelModel.getClass().getSimpleName()) {
                case "Message": {
                    Message message = (Message)channelModel;
                    this.handleMessageLog(message);
                    this.addMessage(message);
                    this.view.showBottomPreview(this.dictionary.get(Manager.class, message.getPersonId()), message);
                    break;
                }
                case "File": 
                case "WebPage": 
                case "Bot": 
                case "Manager": {
                    this.dictionary.add(channelModel);
                    break;
                }
                case "UserChat": {
                    this.handleUserChatData((UserChat)channelModel);
                }
            }
        }
    }

    private void handleUserChatData(UserChat userChat) {
        if (userChat == null || !this.chatId.equals(userChat.getId())) {
            return;
        }
        if (userChat.isStateRemoved()) {
            this.leaveChat();
            this.view.onRemovedChat();
        } else if (userChat.isStateCompleted()) {
            this.adapterModel.addMessageItem(userChat);
            this.view.scrollToBottom(false);
        }
    }

    private void handleMessageLog(Message message) {
        if (CompareUtils.isSame(message.getChatId(), this.chatId)) {
            if (message.getLog() == null) {
                return;
            }
            if (message.getLog().isResolve()) {
                this.isStateCompleted = true;
                this.userChat.setState("resolved");
            } else if (message.getLog().isClose()) {
                this.isStateCompleted = true;
                this.userChat.setState("closed");
            } else {
                this.isStateCompleted = false;
            }
            this.adapterModel.setUserChat(this.userChat);
            this.view.setInputLayoutVisibility();
        }
    }

    private void readAll() {
        ChannelPlugin.getApi().readAll(this.chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        switch (command) {
            case APP_STARTED: {
                this.refresh();
                break;
            }
            case SOCKET_DISCONNECTED: {
                ++this.fetchCounter;
                if (this.isStateEquals(ChatState.IDLE)) break;
                this.setState(ChatState.USER_CHAT_NOT_LOADED, true);
                break;
            }
            case SOCKET_ERROR: {
                this.view.setReconnectVisibility(true);
                break;
            }
            case READY: {
                this.view.setReconnectVisibility(false);
                if (this.isStateEquals(ChatState.WAITING_SOCKET)) {
                    this.joinChat();
                    break;
                }
                this.refresh();
                break;
            }
            case LEAVED: {
                if (object == null || CompareUtils.compare(this.chatId, (String)object) != 0 || !this.isStateEquals(ChatState.CHAT_READY)) break;
                this.setState(ChatState.NOT_JOINED, false);
                break;
            }
            case JOINED: {
                if (object == null || CompareUtils.compare(this.chatId, (String)object) != 0 || !this.isStateEquals(ChatState.CHAT_JOINING)) break;
                this.view.setReconnectVisibility(false);
                this.fetchMessages();
            }
        }
    }

    @Override
    public void messageClicked(Message message) {
        if (message.getFile() != null) {
            if (message.getFile().getPreviewThumb() == null || !message.getFile().isImage()) {
                this.view.onFileDownload(message);
            } else {
                this.adapterModel.setImageFilesToStorage();
                this.view.onShowPhotoAlbum(message.getFile());
            }
        } else if (message.getWebPage() != null) {
            this.urlClicked(message.getWebPage().getUrl());
        }
    }

    @Override
    public void urlClicked(String url) {
        this.view.onUrlClicked(url);
    }

    @Override
    public void actionMessageClicked(ActionMessageItem item) {
        if (item != null && item.getActionType() != null) {
            switch (item.getActionType()) {
                case REQUEST_WORKING_TIME: {
                    item.setActionType(null);
                    this.adapterModel.addMessageItem(item);
                    QuestionMessageItem questionItem = new QuestionMessageItem(this.forwardTimestamp, ResUtils.getString(this.context, "ch.out_of_work.user_answer"), item.getOrder() + 1);
                    this.adapterModel.addMessageItem(questionItem);
                    this.view.scrollToBottom(true);
                    String workingTime = ChannelStore.getChannel() != null ? ChannelStore.getChannel().getWorkingTime(this.context) : "?";
                    this.addMessageDelay(new ActionMessageItem(null, workingTime, null, item.getOrder() + 2));
                }
            }
        }
    }

    @Override
    public void sendingMessageClicked(SendingMessageItem item) {
        this.view.sendingMessageClicked(item);
    }

    @Override
    public void resend(SendingMessageItem item) {
        if (item != null) {
            this.removeFailedItem(item);
            item.refreshCreatedAt();
            this.adapterModel.addMessageItem(item);
            this.getChatManager().send(item, (OnMessageSendListener)this);
        }
    }

    @Override
    public void removeFailedItem(SendingMessageItem item) {
        if (item != null) {
            this.adapterModel.removeMessageItem(item);
            this.getChatManager().removeFailedItem(item.getCreatedAt());
        }
    }

    @Override
    public void sendSuccessed(SendingMessageItem item, Message message) {
        this.adapterModel.removeMessageItem(item);
        this.receiveData(message, true);
    }

    @Override
    public void sendFailed(SendingMessageItem item) {
        this.adapterModel.addMessageItem(item);
    }

    @Override
    public UserInfoItem getUserInfoItem() {
        return this.userInfoItem;
    }

    @Override
    public ProfileEntity getProfile(String personType, String personId) {
        ProfileEntity profile = this.dictionary.getProfile(personType, personId);
        if (profile != null) {
            return profile;
        }
        return ChannelStore.getChannel();
    }

    @Override
    public void refresh() {
        switch (this.state) {
            case USER_CHAT_NOT_LOADED: {
                if (this.chatId != null) {
                    this.fetchUserChat();
                    break;
                }
                this.createUserChat();
                break;
            }
            case WAITING_SOCKET: {
                SocketManager.connect();
                break;
            }
            case NOT_JOINED: {
                this.setState(ChatState.CHAT_JOINING, true);
                SocketManager.joinChat(this.chatId);
                break;
            }
            case MESSAGES_NOT_LOADED: {
                this.fetchMessages();
            }
        }
    }

    private void setState(ChatState state, boolean showRefresh) {
        this.state = state;
        this.view.setRefreshVisibility(showRefresh);
    }

    private boolean isStateEquals(ChatState targetState) {
        return targetState.equals((Object)this.state);
    }

    private void addMessageDelay(final ActionMessageItem item) {
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                item.setTimestamp(ChatPresenter.this.forwardTimestamp);
                ChatPresenter.this.adapterModel.addMessageItem(item);
                ChatPresenter.this.view.scrollToBottom(true);
            }
        }, 750L);
    }

    @Override
    public void userInfoChanged(Object object) {
        if (this.userInfoItem != null) {
            switch (this.userInfoItem.getUserInfoType()) {
                case NAME: {
                    if (!(object instanceof String)) break;
                    this.userInfoItem.setObject(object);
                    break;
                }
                case MOBILE_NUMBER: {
                    if (!(object instanceof MobileNumberItem)) break;
                    this.userInfoItem.setObject(object);
                }
            }
        }
    }

    @Override
    public void sendUserInfo() {
        if (this.userInfoItem != null && this.userInfoItem.getObject() != null) {
            RequestUtils requestUtils = null;
            switch (this.userInfoItem.getUserInfoType()) {
                case NAME: {
                    if (!(this.userInfoItem.getObject() instanceof String)) break;
                    requestUtils = RequestUtils.form().set("name", (String)this.userInfoItem.getObject());
                    break;
                }
                case MOBILE_NUMBER: {
                    if (!(this.userInfoItem.getObject() instanceof MobileNumberItem)) break;
                    MobileNumberItem item = (MobileNumberItem)this.userInfoItem.getObject();
                    requestUtils = RequestUtils.form().set("mobileNumber", String.format("+%s%s", item.getCountry(), item.getMobileNumber()));
                    break;
                }
                default: {
                    return;
                }
            }
            if (requestUtils != null) {
                ChannelPlugin.getApi().updateGuest(requestUtils.create()).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserVeilWrapper>(){

                    @Override
                    public void onError(Throwable e) {
                        L.e(e.getMessage());
                        ChatPresenter.this.userInfoItem.setError(true);
                        ChatPresenter.this.adapterModel.addMessageItem(ChatPresenter.this.userInfoItem);
                    }

                    @Override
                    public void onNext(UserVeilWrapper wrapper) {
                        ChannelStore.setUserVeil(wrapper.getUser(), wrapper.getVeil());
                        ChatPresenter.this.adapterModel.removeMessageItem(ChatPresenter.this.userInfoItem);
                        ChatPresenter.this.checkRequireUserInfo(ChatPresenter.this.userInfoItem.getTimestamp());
                    }
                });
            }
        }
    }

    private void checkRequireUserInfo(long timestamp) {
        boolean flag = false;
        if (this.userInfoItem != null) {
            try {
                this.adapterModel.removeMessageItem(this.userInfoItem);
                this.userInfoItem = null;
                flag = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!ChannelStore.hasName()) {
            this.userInfoItem = new UserInfoItem(UserInfoType.NAME, timestamp, false, null);
        } else if (ChannelStore.getMobileNumber() == null) {
            this.userInfoItem = new UserInfoItem(UserInfoType.MOBILE_NUMBER, timestamp, false, new MobileNumberItem(this.countryDictionary.getDefaultCountryCode(), ""));
        }
        if (this.userInfoItem != null) {
            Observable.timer((long)512L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Long>(){

                public void call(Long aLong) {
                    ChatPresenter.this.adapterModel.addMessageItem(ChatPresenter.this.userInfoItem);
                    if (ChatPresenter.this.isUserInfoFirst) {
                        ChatPresenter.this.isUserInfoFirst = false;
                        ChatPresenter.this.view.scrollToBottom(true);
                    }
                }
            });
        } else if (flag) {
            this.userInfoItem = new UserInfoItem(UserInfoType.COMPLETE, timestamp, false, null);
            this.adapterModel.addMessageItem(this.userInfoItem);
        }
    }

    @Override
    public void onMessageReview(String review, ResolveMessageItem resolveMessageItem) {
        ChannelPlugin.getApi().reviewUserChat(this.chatId, review).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserChatWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                L.e(error.getMessage());
            }

            @Override
            public void onNext(UserChatWrapper userChatWrapper) {
                UserChat userChat;
                if (userChatWrapper != null && (userChat = userChatWrapper.getUserChat()) != null) {
                    ChatPresenter.this.adapterModel.addMessageItem(userChat);
                }
            }
        });
    }

    @Override
    public void leaveChat() {
        SocketManager.leaveChat(this.chatId);
    }

    private ChatManager getChatManager() {
        return ChatManager.get();
    }
}

