/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.client;

import com.zoyi.io.socket.client.Manager;
import com.zoyi.io.socket.client.Socket;
import com.zoyi.io.socket.client.Url;
import com.zoyi.io.socket.parser.Parser;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class IO {
    private static final Logger logger = Logger.getLogger(IO.class.getName());
    private static final ConcurrentHashMap<String, Manager> managers = new ConcurrentHashMap();
    public static int protocol = Parser.protocol;

    public static void setDefaultSSLContext(SSLContext sslContext) {
        Manager.defaultSSLContext = sslContext;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        Manager.defaultHostnameVerifier = hostnameVerifier;
    }

    private IO() {
    }

    public static Socket socket(String uri) throws URISyntaxException {
        return IO.socket(uri, null);
    }

    public static Socket socket(String uri, Options opts) throws URISyntaxException {
        return IO.socket(new URI(uri), opts);
    }

    public static Socket socket(URI uri) {
        return IO.socket(uri, null);
    }

    public static Socket socket(URI uri, Options opts) {
        Manager io;
        boolean newConnection;
        URI source;
        if (opts == null) {
            opts = new Options();
        }
        URL parsed = Url.parse(uri);
        try {
            source = parsed.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String id = Url.extractId(parsed);
        String path = parsed.getPath();
        boolean sameNamespace = managers.containsKey(id) && IO.managers.get((Object)id).nsps.containsKey(path);
        boolean bl = newConnection = opts.forceNew || !opts.multiplex || sameNamespace;
        if (newConnection) {
            logger.fine(String.format("ignoring socket cache for %s", source));
            io = new Manager(source, opts);
        } else {
            if (!managers.containsKey(id)) {
                logger.fine(String.format("new io instance for %s", source));
                managers.putIfAbsent(id, new Manager(source, opts));
            }
            io = managers.get(id);
        }
        return io.socket(parsed.getPath());
    }

    public static class Options
    extends Manager.Options {
        public boolean forceNew;
        public boolean multiplex = true;
    }
}

