package com.zoyi.channel.plugin.android.presenter.photopicker;

import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.presenter.BasePresenter;
import com.zoyi.channel.plugin.android.presenter.BaseView;

import java.util.ArrayList;

public interface PhotoPickerContract {

  interface View extends BaseView<Presenter> {

    void loadPhotoItems(ArrayList<PhotoItem> photoItems);
    void sendPhotoPaths(ArrayList<String> imagePaths);
    void setMenuState(int selectedCount);
  }

  interface Presenter extends BasePresenter {

    void setView(PhotoPickerContract.View view);
    void setAdapterView(PhotoPickerAdapterContract.View adapterView);
    void setAdapterModel(PhotoPickerAdapterContract.Model adapterModel);
    void fetchPhotoItems();
    void collectSelectedPhotoItem();
  }

}
