package com.zoyi.channel.plugin.android.network;

import com.zoyi.retrofit2.Call;
import com.zoyi.retrofit2.CallAdapter;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import com.zoyi.rx.Observable;
import com.zoyi.rx.functions.Func1;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

/**
 * Created by mika on 2017. 1. 9..
 */
public class RxAdapterFactory extends CallAdapter.Factory {
  private final RxJavaCallAdapterFactory original;

  private RxAdapterFactory() {
    original = RxJavaCallAdapterFactory.create();
  }

  public static CallAdapter.Factory create() {
    return new RxAdapterFactory();
  }

  @Override
  public CallAdapter<?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
    return new RxCallAdapterWrapper(retrofit, original.get(returnType, annotations, retrofit));
  }

  private static class RxCallAdapterWrapper implements CallAdapter<Observable<?>> {
    private final Retrofit retrofit;
    private final CallAdapter<?> wrapped;

    RxCallAdapterWrapper(Retrofit retrofit, CallAdapter<?> wrapped) {
      this.retrofit = retrofit;
      this.wrapped = wrapped;
    }

    @Override
    public Type responseType() {
      return wrapped.responseType();
    }

    @SuppressWarnings("unchecked")
    @Override
    public <R> Observable<?> adapt(Call<R> call) {
      return ((Observable) wrapped.adapt(call)).onErrorResumeNext(new Func1<Throwable, Observable>() {
        @Override
        public Observable call(Throwable throwable) {
          return Observable.error(RetrofitException.create(throwable));
        }
      });
    }
  }
}
