package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;

/**
 * Created by mika on 2017. 2. 7..
 */
public class UserInfoItem implements MessageItem {
  private UserInfoType userInfoType;
  private Long timestamp;
  private boolean error;
  private Object object;

  public UserInfoItem(UserInfoType userInfoType, Long timestamp, boolean error, Object object) {
    this.userInfoType = userInfoType;
    this.timestamp = timestamp + 1;
    this.error = error;
    this.object = object;
  }

  @Override
  public Long getFirst() {
    return timestamp;
  }

  @Override
  public String getSecond() {
    return "UserInfoItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.USER_INFO;
  }

  public UserInfoType getUserInfoType() {
    return userInfoType;
  }

  public Long getTimestamp() {
    return timestamp;
  }

  public Object getObject() {
    return object;
  }

  public void setObject(Object object) {
    this.object = object;
  }

  public boolean isError() {
    return error;
  }

  public void setError(boolean error) {
    this.error = error;
  }
}
