/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subscriptions;

import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class CompositeSubscription
implements Subscription {
    private Set<Subscription> subscriptions;
    private volatile boolean unsubscribed;

    public CompositeSubscription() {
    }

    public CompositeSubscription(Subscription ... subscriptionArray) {
        this.subscriptions = new HashSet<Subscription>(Arrays.asList(subscriptionArray));
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(Subscription subscription) {
        if (subscription.isUnsubscribed()) {
            return;
        }
        if (!this.unsubscribed) {
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                if (!this.unsubscribed) {
                    if (this.subscriptions == null) {
                        this.subscriptions = new HashSet<Subscription>(4);
                    }
                    this.subscriptions.add(subscription);
                    return;
                }
            }
        }
        subscription.unsubscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void addAll(Subscription ... subscriptionArray) {
        Subscription[] subscriptionArray2;
        if (!this.unsubscribed) {
            subscriptionArray2 = this;
            // MONITORENTER : this
            if (!this.unsubscribed) {
                if (this.subscriptions == null) {
                    this.subscriptions = new HashSet<Subscription>(subscriptionArray.length);
                }
                int n2 = subscriptionArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        // MONITOREXIT : subscriptionArray2
                        return;
                    }
                    Subscription subscription = subscriptionArray[n3];
                    if (!subscription.isUnsubscribed()) {
                        this.subscriptions.add(subscription);
                    }
                    ++n3;
                }
            }
            // MONITOREXIT : subscriptionArray2
        }
        subscriptionArray2 = subscriptionArray;
        int n4 = subscriptionArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Subscription subscription = subscriptionArray2[n5];
            subscription.unsubscribe();
            ++n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Subscription subscription) {
        if (!this.unsubscribed) {
            boolean bl;
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                if (this.unsubscribed || this.subscriptions == null) {
                    return;
                }
                bl = this.subscriptions.remove(subscription);
            }
            if (bl) {
                subscription.unsubscribe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        if (!this.unsubscribed) {
            Set<Subscription> set;
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                if (this.unsubscribed || this.subscriptions == null) {
                    return;
                }
                set = this.subscriptions;
                this.subscriptions = null;
            }
            CompositeSubscription.unsubscribeFromAll(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unsubscribe() {
        if (!this.unsubscribed) {
            Set<Subscription> set;
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                if (this.unsubscribed) {
                    return;
                }
                this.unsubscribed = true;
                set = this.subscriptions;
                this.subscriptions = null;
            }
            CompositeSubscription.unsubscribeFromAll(set);
        }
    }

    private static void unsubscribeFromAll(Collection<Subscription> object) {
        if (object == null) {
            return;
        }
        ArrayList<Throwable> arrayList = null;
        object = object.iterator();
        while (object.hasNext()) {
            Subscription subscription = (Subscription)object.next();
            try {
                subscription.unsubscribe();
            }
            catch (Throwable throwable) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Throwable>();
                }
                arrayList.add(throwable);
            }
        }
        Exceptions.throwIfAny(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasSubscriptions() {
        if (!this.unsubscribed) {
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                return !this.unsubscribed && this.subscriptions != null && !this.subscriptions.isEmpty();
            }
        }
        return false;
    }
}

