/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.singles;

import com.zoyi.rx.Single;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.BlockingOperatorToFuture;
import com.zoyi.rx.internal.util.BlockingUtils;
import com.zoyi.rx.singles.BlockingSingle$1;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

@Experimental
public final class BlockingSingle<T> {
    private final Single<? extends T> single;

    private BlockingSingle(Single<? extends T> single) {
        this.single = single;
    }

    @Experimental
    public static <T> BlockingSingle<T> from(Single<? extends T> single) {
        return new BlockingSingle<T>(single);
    }

    @Experimental
    public final T value() {
        AtomicReference atomicReference = new AtomicReference();
        Serializable serializable = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Subscription subscription = this.single.subscribe(new BlockingSingle$1(this, atomicReference, countDownLatch, (AtomicReference)serializable));
        BlockingUtils.awaitForComplete(countDownLatch, subscription);
        serializable = (Throwable)serializable.get();
        if (serializable != null) {
            throw Exceptions.propagate(serializable);
        }
        return (T)atomicReference.get();
    }

    @Experimental
    public final Future<T> toFuture() {
        return BlockingOperatorToFuture.toFuture(this.single.toObservable());
    }
}

