/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.observers;

import com.zoyi.rx.Notification;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.observers.TestSubscriber$1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TestSubscriber<T>
extends Subscriber<T> {
    private final Observer<T> delegate;
    private final List<T> values;
    private final List<Throwable> errors;
    private int completions;
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile int valueCount;
    private volatile Thread lastSeenThread;
    private static final Observer<Object> INERT = new TestSubscriber$1();

    public TestSubscriber(long l2) {
        this(INERT, l2);
    }

    public TestSubscriber(Observer<T> observer, long l2) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.delegate = observer;
        if (l2 >= 0L) {
            this.request(l2);
        }
        this.values = new ArrayList<T>();
        this.errors = new ArrayList<Throwable>();
    }

    public TestSubscriber(Subscriber<T> subscriber) {
        this(subscriber, -1L);
    }

    public TestSubscriber(Observer<T> observer) {
        this(observer, -1L);
    }

    public TestSubscriber() {
        this(-1L);
    }

    public static <T> TestSubscriber<T> create() {
        return new TestSubscriber<T>();
    }

    public static <T> TestSubscriber<T> create(long l2) {
        return new TestSubscriber<T>(l2);
    }

    public static <T> TestSubscriber<T> create(Observer<T> observer, long l2) {
        return new TestSubscriber<T>(observer, l2);
    }

    public static <T> TestSubscriber<T> create(Subscriber<T> subscriber) {
        return new TestSubscriber<T>(subscriber);
    }

    public static <T> TestSubscriber<T> create(Observer<T> observer) {
        return new TestSubscriber<T>(observer);
    }

    @Override
    public void onCompleted() {
        try {
            ++this.completions;
            this.lastSeenThread = Thread.currentThread();
            this.delegate.onCompleted();
            return;
        }
        finally {
            this.latch.countDown();
        }
    }

    @Deprecated
    public List<Notification<T>> getOnCompletedEvents() {
        int n2 = this.completions;
        ArrayList<Notification<T>> arrayList = new ArrayList<Notification<T>>(n2 != 0 ? n2 : 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(Notification.createOnCompleted());
        }
        return arrayList;
    }

    @Experimental
    public final int getCompletions() {
        return this.completions;
    }

    @Override
    public void onError(Throwable throwable) {
        try {
            this.lastSeenThread = Thread.currentThread();
            this.errors.add(throwable);
            this.delegate.onError(throwable);
            return;
        }
        finally {
            this.latch.countDown();
        }
    }

    public List<Throwable> getOnErrorEvents() {
        return this.errors;
    }

    @Override
    public void onNext(T t2) {
        this.lastSeenThread = Thread.currentThread();
        this.values.add(t2);
        this.valueCount = this.values.size();
        this.delegate.onNext(t2);
    }

    public final int getValueCount() {
        return this.valueCount;
    }

    public void requestMore(long l2) {
        this.request(l2);
    }

    public List<T> getOnNextEvents() {
        return this.values;
    }

    public void assertReceivedOnNext(List<T> list) {
        if (this.values.size() != list.size()) {
            this.assertionError("Number of items does not match. Provided: " + list.size() + "  Actual: " + this.values.size() + ".\nProvided values: " + list + "\nActual values: " + this.values + "\n");
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.assertItem(list.get(i2), i2);
        }
    }

    private void assertItem(T t2, int n2) {
        T t3 = this.values.get(n2);
        if (t2 == null) {
            if (t3 != null) {
                this.assertionError("Value at index: " + n2 + " expected to be [null] but was: [" + t3 + "]\n");
                return;
            }
        } else if (!t2.equals(t3)) {
            this.assertionError("Value at index: " + n2 + " expected to be [" + t2 + "] (" + t2.getClass().getSimpleName() + ") but was: [" + t3 + "] (" + (t3 != null ? t3.getClass().getSimpleName() : "null") + ")\n");
        }
    }

    @Experimental
    public final boolean awaitValueCount(int n2, long l2, TimeUnit timeUnit) {
        while (l2 != 0L && this.valueCount < n2) {
            try {
                timeUnit.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException("Interrupted", interruptedException);
            }
            --l2;
        }
        return this.valueCount >= n2;
    }

    public void assertTerminalEvent() {
        if (this.errors.size() > 1) {
            this.assertionError("Too many onError events: " + this.errors.size());
        }
        if (this.completions > 1) {
            this.assertionError("Too many onCompleted events: " + this.completions);
        }
        if (this.completions == 1 && this.errors.size() == 1) {
            this.assertionError("Received both an onError and onCompleted. Should be one or the other.");
        }
        if (this.completions == 0 && this.errors.isEmpty()) {
            this.assertionError("No terminal events received.");
        }
    }

    public void assertUnsubscribed() {
        if (!this.isUnsubscribed()) {
            this.assertionError("Not unsubscribed.");
        }
    }

    public void assertNoErrors() {
        List<Throwable> list = this.getOnErrorEvents();
        if (!list.isEmpty()) {
            this.assertionError("Unexpected onError events");
        }
    }

    public void awaitTerminalEvent() {
        try {
            this.latch.await();
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Interrupted", interruptedException);
        }
    }

    public void awaitTerminalEvent(long l2, TimeUnit timeUnit) {
        try {
            this.latch.await(l2, timeUnit);
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Interrupted", interruptedException);
        }
    }

    public void awaitTerminalEventAndUnsubscribeOnTimeout(long l2, TimeUnit timeUnit) {
        try {
            boolean bl = this.latch.await(l2, timeUnit);
            if (!bl) {
                this.unsubscribe();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.unsubscribe();
            return;
        }
    }

    public Thread getLastSeenThread() {
        return this.lastSeenThread;
    }

    public void assertCompleted() {
        int n2 = this.completions;
        if (n2 == 0) {
            this.assertionError("Not completed!");
            return;
        }
        if (n2 > 1) {
            this.assertionError("Completed multiple times: " + n2);
        }
    }

    public void assertNotCompleted() {
        int n2 = this.completions;
        if (n2 == 1) {
            this.assertionError("Completed!");
            return;
        }
        if (n2 > 1) {
            this.assertionError("Completed multiple times: " + n2);
        }
    }

    public void assertError(Class<? extends Throwable> object) {
        List<Throwable> list = this.errors;
        if (list.isEmpty()) {
            this.assertionError("No errors");
            return;
        }
        if (list.size() > 1) {
            object = new AssertionError((Object)("Multiple errors: " + list.size()));
            ((Throwable)object).initCause(new CompositeException(list));
            throw object;
        }
        if (!((Class)object).isInstance(list.get(0))) {
            object = new AssertionError((Object)("Exceptions differ; expected: " + object + ", actual: " + list.get(0)));
            ((Throwable)object).initCause(list.get(0));
            throw object;
        }
    }

    public void assertError(Throwable throwable) {
        List<Throwable> list = this.errors;
        if (list.isEmpty()) {
            this.assertionError("No errors");
            return;
        }
        if (list.size() > 1) {
            this.assertionError("Multiple errors");
            return;
        }
        if (!throwable.equals(list.get(0))) {
            this.assertionError("Exceptions differ; expected: " + throwable + ", actual: " + list.get(0));
        }
    }

    public void assertNoTerminalEvent() {
        List<Throwable> list = this.errors;
        int n2 = this.completions;
        if (!list.isEmpty() || n2 > 0) {
            if (list.isEmpty()) {
                this.assertionError("Found " + list.size() + " errors and " + n2 + " completion events instead of none");
                return;
            }
            if (list.size() == 1) {
                this.assertionError("Found " + list.size() + " errors and " + n2 + " completion events instead of none");
                return;
            }
            this.assertionError("Found " + list.size() + " errors and " + n2 + " completion events instead of none");
        }
    }

    public void assertNoValues() {
        int n2 = this.values.size();
        if (n2 != 0) {
            this.assertionError("No onNext events expected yet some received: " + n2);
        }
    }

    public void assertValueCount(int n2) {
        int n3 = this.values.size();
        if (n3 != n2) {
            this.assertionError("Number of onNext events differ; expected: " + n2 + ", actual: " + n3);
        }
    }

    public void assertValues(T ... TArray) {
        this.assertReceivedOnNext(Arrays.asList(TArray));
    }

    public void assertValue(T t2) {
        this.assertReceivedOnNext(Collections.singletonList(t2));
    }

    final void assertionError(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 32);
        stringBuilder.append(string).append(" (");
        int n2 = this.completions;
        stringBuilder.append(n2).append(" completion");
        if (n2 != 1) {
            stringBuilder.append('s');
        }
        stringBuilder.append(')');
        if (!this.errors.isEmpty()) {
            n2 = this.errors.size();
            stringBuilder.append(" (+").append(n2).append(" error");
            if (n2 != 1) {
                stringBuilder.append('s');
            }
            stringBuilder.append(')');
        }
        AssertionError assertionError = new AssertionError((Object)stringBuilder.toString());
        if (!this.errors.isEmpty()) {
            if (this.errors.size() == 1) {
                ((Throwable)((Object)assertionError)).initCause(this.errors.get(0));
            } else {
                ((Throwable)((Object)assertionError)).initCause(new CompositeException(this.errors));
            }
        }
        throw assertionError;
    }

    @Experimental
    public final void assertValuesAndClear(T t2, T ... TArray) {
        int n2 = 1 + TArray.length;
        this.assertValueCount(n2);
        this.assertItem(t2, 0);
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            this.assertItem(TArray[i2], i2 + 1);
        }
        this.values.clear();
    }
}

