/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.unsafe;

import com.zoyi.rx.internal.util.SuppressAnimalSniffer;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueueL3Pad;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;

@SuppressAnimalSniffer
public final class SpscArrayQueue<E>
extends SpscArrayQueueL3Pad<E> {
    public SpscArrayQueue(int n2) {
        super(n2);
    }

    @Override
    public final boolean offer(E e2) {
        if (e2 == null) {
            throw new NullPointerException("null elements not allowed");
        }
        Object[] objectArray = this.buffer;
        long l2 = this.producerIndex;
        long l3 = this.calcElementOffset(l2);
        if (null != this.lvElement(objectArray, l3)) {
            return false;
        }
        this.soElement(objectArray, l3, e2);
        this.soProducerIndex(l2 + 1L);
        return true;
    }

    @Override
    public final E poll() {
        Object[] objectArray = this.buffer;
        long l2 = this.consumerIndex;
        long l3 = this.calcElementOffset(l2);
        Object object = this.lvElement(objectArray, l3);
        if (object == null) {
            return null;
        }
        this.soElement(objectArray, l3, null);
        this.soConsumerIndex(l2 + 1L);
        return (E)object;
    }

    @Override
    public final E peek() {
        return this.lvElement(this.calcElementOffset(this.consumerIndex));
    }

    @Override
    public final int size() {
        long l2;
        long l3;
        long l4 = this.lvConsumerIndex();
        do {
            l3 = l4;
            l2 = this.lvProducerIndex();
        } while (l3 != (l4 = this.lvConsumerIndex()));
        return (int)(l2 - l4);
    }

    @Override
    public final boolean isEmpty() {
        return this.lvProducerIndex() == this.lvConsumerIndex();
    }

    private void soProducerIndex(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, l2);
    }

    private void soConsumerIndex(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, l2);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }
}

