/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.unsafe;

import com.zoyi.rx.internal.util.SuppressAnimalSniffer;
import com.zoyi.rx.internal.util.unsafe.ConcurrentCircularArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;

@SuppressAnimalSniffer
public abstract class ConcurrentSequencedCircularArrayQueue<E>
extends ConcurrentCircularArrayQueue<E> {
    private static final long ARRAY_BASE;
    private static final int ELEMENT_SHIFT;
    protected final long[] sequenceBuffer;

    public ConcurrentSequencedCircularArrayQueue(int n2) {
        super(n2);
        n2 = (int)(this.mask + 1L);
        this.sequenceBuffer = new long[(n2 << SPARSE_SHIFT) + 64];
        for (long i2 = 0L; i2 < (long)n2; ++i2) {
            this.soSequence(this.sequenceBuffer, this.calcSequenceOffset(i2), i2);
        }
    }

    protected final long calcSequenceOffset(long l2) {
        return ARRAY_BASE + ((l2 & this.mask) << ELEMENT_SHIFT);
    }

    protected final void soSequence(long[] lArray, long l2, long l3) {
        UnsafeAccess.UNSAFE.putOrderedLong(lArray, l2, l3);
    }

    protected final long lvSequence(long[] lArray, long l2) {
        return UnsafeAccess.UNSAFE.getLongVolatile(lArray, l2);
    }

    static {
        int n2 = UnsafeAccess.UNSAFE.arrayIndexScale(long[].class);
        if (8 != n2) {
            throw new IllegalStateException("Unexpected long[] element size");
        }
        ELEMENT_SHIFT = 3 + SPARSE_SHIFT;
        ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class) + (32 << ELEMENT_SHIFT - SPARSE_SHIFT);
    }
}

